/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.PropertyAccess1;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestPropertyAccess
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(PropertyAccess1.class, CLEAR_TABLES);
    }

    public void testPropertyAccessBasicCreation() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PropertyAccess1 pa1_1 = new PropertyAccess1(10);
        pa1_1.setName("foo");
        em.persist((Object)pa1_1);
        em.getTransaction().commit();
        em = this.emf.createEntityManager();
        PropertyAccess1 pa1_2 = (PropertyAccess1)em.find(PropertyAccess1.class, (Object)10);
        TestPropertyAccess.assertNotSame((Object)pa1_1, (Object)pa1_2);
        TestPropertyAccess.assertNotNull((Object)pa1_2);
        TestPropertyAccess.assertEquals((int)10, (int)pa1_2.getId());
        TestPropertyAccess.assertEquals((String)"foo", (String)pa1_2.getName());
    }

    public void testPropertyAccessBasicMutation() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PropertyAccess1 pa1_1 = new PropertyAccess1(10);
        pa1_1.setName("foo");
        em.persist((Object)pa1_1);
        em.getTransaction().commit();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        PropertyAccess1 pa1_2 = (PropertyAccess1)em.find(PropertyAccess1.class, (Object)10);
        pa1_2.setName(pa1_2.getName() + "bar");
        em.getTransaction().commit();
        em = this.emf.createEntityManager();
        PropertyAccess1 pa1_3 = (PropertyAccess1)em.find(PropertyAccess1.class, (Object)10);
        TestPropertyAccess.assertNotSame((Object)pa1_2, (Object)pa1_3);
        TestPropertyAccess.assertEquals((String)"foobar", (String)pa1_3.getName());
    }

    public void testJPQL() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.createQuery("select o from PropertyAccess1 o where o.name = 'foo'").getResultList();
        em.createQuery("select o from PropertyAccess1 o order by o.name asc").getResultList();
        em.close();
    }

    public void testJPQLWithFieldNameMismatch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.createQuery("select o from PropertyAccess1 o where o.intValue = 0").getResultList();
        em.createQuery("select o from PropertyAccess1 o order by o.intValue asc").getResultList();
        em.close();
    }
}

