/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.ClobValueHandler;
import org.apache.openjpa.jdbc.meta.strats.EmbedFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.FullClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedClobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.NoneClassStrategy;
import org.apache.openjpa.jdbc.meta.strats.RelationFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.StringFieldStrategy;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.EmbeddableSuper;
import org.apache.openjpa.persistence.jdbc.annotations.EmbeddableSuperSub;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEmbeddableSuperclass
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(EmbeddableSuper.class, EmbeddableSuperSub.class, CLEAR_TABLES);
    }

    public void testSuperclassEmbeddedOnly() {
        ClassMapping cls = ((JDBCConfiguration)this.emf.getConfiguration()).getMappingRepositoryInstance().getMapping(EmbeddableSuper.class, null, true);
        TestEmbeddableSuperclass.assertTrue((boolean)cls.isEmbeddedOnly());
        TestEmbeddableSuperclass.assertEquals((Object)NoneClassStrategy.getInstance(), (Object)cls.getStrategy());
    }

    public void testSubclassMappingDefaultsAndOverrides() {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        ClassMapping cls = conf.getMappingRepositoryInstance().getMapping(EmbeddableSuperSub.class, null, true);
        TestEmbeddableSuperclass.assertTrue((!cls.isEmbeddedOnly() ? 1 : 0) != 0);
        TestEmbeddableSuperclass.assertTrue((boolean)(cls.getStrategy() instanceof FullClassStrategy));
        TestEmbeddableSuperclass.assertEquals((int)2, (int)cls.getIdentityType());
        TestEmbeddableSuperclass.assertTrue((boolean)cls.isOpenJPAIdentity());
        FieldMapping fm = cls.getFieldMapping("pk");
        TestEmbeddableSuperclass.assertTrue((boolean)fm.isPrimaryKey());
        TestEmbeddableSuperclass.assertEquals((int)2, (int)fm.getValueStrategy());
        TestEmbeddableSuperclass.assertEquals((String)"ID", (String)fm.getColumns()[0].getName());
        TestEmbeddableSuperclass.assertNull((Object)cls.getField("trans"));
        fm = cls.getFieldMapping("clob");
        TestEmbeddableSuperclass.assertEquals((String)"CC", (String)fm.getColumns()[0].getName());
        DBDictionary dict = conf.getDBDictionaryInstance();
        if (dict.getPreferredType(2005) == 2005) {
            if (dict.maxEmbeddedClobSize > 0) {
                TestEmbeddableSuperclass.assertTrue((boolean)(fm.getStrategy() instanceof MaxEmbeddedClobFieldStrategy));
            } else {
                TestEmbeddableSuperclass.assertTrue((boolean)(fm.getHandler() instanceof ClobValueHandler));
            }
        } else {
            TestEmbeddableSuperclass.assertTrue((boolean)(fm.getStrategy() instanceof StringFieldStrategy));
        }
    }

    public void testSubclassDiscriminatorMapping() {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        ClassMapping cls = conf.getMappingRepositoryInstance().getMapping(EmbeddableSuperSub.class, null, true);
        TestEmbeddableSuperclass.assertEquals((String)"DISC", (String)cls.getDiscriminator().getColumns()[0].getName());
    }

    public void testVersionOverrideMapping() {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        ClassMapping cls = conf.getMappingRepositoryInstance().getMapping(EmbeddableSuperSub.class, null, true);
        TestEmbeddableSuperclass.assertEquals((String)"VERSVAL", (String)cls.getVersion().getColumns()[0].getName());
    }

    public void testRelationMappings() {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        ClassMapping cls = conf.getMappingRepositoryInstance().getMapping(EmbeddableSuperSub.class, null, true);
        FieldMapping fm = cls.getFieldMapping("sub");
        TestEmbeddableSuperclass.assertTrue((boolean)(fm.getStrategy() instanceof RelationFieldStrategy));
        fm = cls.getFieldMapping("sup");
        TestEmbeddableSuperclass.assertTrue((boolean)(fm.getStrategy() instanceof EmbedFieldStrategy));
    }

    public void testPersistAndFind() {
        EmbeddableSuperSub parent = new EmbeddableSuperSub();
        parent.setClob("parent");
        EmbeddableSuperSub sub = new EmbeddableSuperSub();
        sub.setClob("sub");
        EmbeddableSuperSub sup = new EmbeddableSuperSub();
        sup.setClob("sup");
        parent.setSub(sub);
        parent.setSup(sup);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persistAll(new Object[]{parent, sub, sup});
        em.getTransaction().commit();
        long pk = parent.getPK();
        em.close();
        em = this.emf.createEntityManager();
        parent = (EmbeddableSuperSub)em.find(EmbeddableSuperSub.class, (Object)pk);
        TestEmbeddableSuperclass.assertEquals((String)"parent", (String)parent.getClob());
        TestEmbeddableSuperclass.assertEquals((String)"sub", (String)parent.getSub().getClob());
        TestEmbeddableSuperclass.assertEquals((String)"sup", (String)parent.getSup().getClob());
        em.close();
    }
}

