/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc.annotations;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.strats.ClobValueHandler;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedClobFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.StringFieldStrategy;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedOwner;
import org.apache.openjpa.persistence.jdbc.annotations.EmbedValue;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEJBEmbedded
extends SingleEMFTestCase {
    private static final String CLOB;

    public void setUp() {
        this.setUp(EmbedOwner.class, EmbedValue.class, CLEAR_TABLES);
    }

    public void testEmbedded() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        EmbedOwner owner = new EmbedOwner();
        owner.setBasic("foo");
        EmbedValue embed = new EmbedValue();
        embed.setClob(CLOB);
        embed.setBasic("bar");
        embed.setBlob("foobar".getBytes());
        embed.setOwner(owner);
        owner.setEmbed(embed);
        em.persist((Object)owner);
        int pk = owner.getPk();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        owner = (EmbedOwner)em.find(EmbedOwner.class, (Object)pk);
        TestEJBEmbedded.assertEquals((String)"foo", (String)owner.getBasic());
        embed = owner.getEmbed();
        TestEJBEmbedded.assertNotNull((Object)embed);
        TestEJBEmbedded.assertEquals((String)CLOB, (String)embed.getClob());
        TestEJBEmbedded.assertEquals((String)"bar", (String)embed.getBasic());
        TestEJBEmbedded.assertEquals((String)"foobar", (String)new String(embed.getBlob()));
        TestEJBEmbedded.assertEquals((Object)owner, (Object)embed.getOwner());
        em.close();
    }

    public void testEmbeddedMetaData() {
        ClassMetaData ownerMeta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, EmbedOwner.class);
        FieldMetaData fmd = ownerMeta.getField("embed");
        ClassMetaData embeddedMeta = fmd.getDefiningMetaData();
        TestEJBEmbedded.assertNotNull((Object)embeddedMeta);
        TestEJBEmbedded.assertNull((Object)embeddedMeta.getField("transientField"));
    }

    public void testNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        EmbedOwner owner = new EmbedOwner();
        owner.setBasic("foo");
        em.persist((Object)owner);
        int pk = owner.getPk();
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        owner = (EmbedOwner)em.find(EmbedOwner.class, (Object)pk);
        TestEJBEmbedded.assertEquals((String)"foo", (String)owner.getBasic());
        EmbedValue embed = owner.getEmbed();
        TestEJBEmbedded.assertNotNull((Object)embed);
        TestEJBEmbedded.assertNull((Object)embed.getClob());
        TestEJBEmbedded.assertNull((Object)embed.getBasic());
        TestEJBEmbedded.assertNull((Object)embed.getBlob());
        em.close();
    }

    public void testMappingTransferAndOverride() {
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        ClassMapping cls = conf.getMappingRepositoryInstance().getMapping(EmbedOwner.class, null, true);
        TestEJBEmbedded.assertEquals((String)"OWN_BASIC", (String)cls.getFieldMapping("basic").getColumns()[0].getName());
        ClassMapping embed = cls.getFieldMapping("embed").getEmbeddedMapping();
        TestEJBEmbedded.assertEquals((String)"EMB_BLOB", (String)embed.getFieldMapping("blob").getColumns()[0].getName());
        TestEJBEmbedded.assertEquals((String)"OVER_BASIC", (String)embed.getFieldMapping("basic").getColumns()[0].getName());
        TestEJBEmbedded.assertEquals((String)"OVER_OWNER", (String)embed.getFieldMapping("owner").getColumns()[0].getName());
        FieldMapping fm = embed.getFieldMapping("clob");
        DBDictionary dict = conf.getDBDictionaryInstance();
        if (dict.getPreferredType(2005) == 2005) {
            if (dict.maxEmbeddedClobSize > 0) {
                TestEJBEmbedded.assertTrue((boolean)(fm.getStrategy() instanceof MaxEmbeddedClobFieldStrategy));
            } else {
                TestEJBEmbedded.assertTrue((boolean)(fm.getHandler() instanceof ClobValueHandler));
            }
        } else {
            TestEJBEmbedded.assertTrue((boolean)(fm.getStrategy() instanceof StringFieldStrategy));
        }
    }

    static {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            buf.append('a');
        }
        CLOB = buf.toString();
    }
}

