/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.polymorphic;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import org.apache.openjpa.persistence.inheritance.polymorphic.BaseEntity;
import org.apache.openjpa.persistence.inheritance.polymorphic.Translation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public abstract class Translatable
extends BaseEntity {
    @OneToMany(mappedBy="translatable", cascade={CascadeType.PERSIST})
    private Set<Translation> translations;

    public void addTranslation(Translation t) {
        if (this.translations == null) {
            this.translations = new HashSet<Translation>();
        }
        this.translations.add(t);
    }

    public Set<Translation> getTranslations() {
        return Collections.unmodifiableSet(this.translations);
    }
}

