/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.polymorphic;

import java.util.List;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.polymorphic.BaseEntity;
import org.apache.openjpa.persistence.inheritance.polymorphic.EnglishParagraph;
import org.apache.openjpa.persistence.inheritance.polymorphic.FrenchParagraph;
import org.apache.openjpa.persistence.inheritance.polymorphic.GermanParagraph;
import org.apache.openjpa.persistence.inheritance.polymorphic.Translatable;
import org.apache.openjpa.persistence.inheritance.polymorphic.Translation;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTablePerClassInheritanceWithAbstractRoot
extends SingleEMFTestCase {
    Class<?>[] UNJOINED_SUBCLASSES = new Class[]{EnglishParagraph.class, FrenchParagraph.class, GermanParagraph.class};

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, Translation.class, BaseEntity.class, EnglishParagraph.class, FrenchParagraph.class, GermanParagraph.class, Translatable.class);
    }

    public void testConsistency() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        int nTranslatableBefore = this.count(this.UNJOINED_SUBCLASSES);
        int nTranslationBefore = this.count((Class)Translation.class);
        EnglishParagraph english = new EnglishParagraph();
        FrenchParagraph french = new FrenchParagraph();
        GermanParagraph german = new GermanParagraph();
        Translation translation1 = new Translation();
        Translation translation2 = new Translation();
        Translation translation3 = new Translation();
        Translation translation4 = new Translation();
        english.setContent("Hello");
        french.setContent("Bon jour");
        german.setContent("Guten Tag");
        translation1.setTranslatable(english);
        translation2.setTranslatable(english);
        translation3.setTranslatable(french);
        translation4.setTranslatable(german);
        english.addTranslation(translation1);
        english.addTranslation(translation2);
        french.addTranslation(translation3);
        german.addTranslation(translation4);
        em.persist((Object)translation1);
        em.persist((Object)translation2);
        em.persist((Object)translation3);
        em.persist((Object)translation4);
        em.getTransaction().commit();
        em.clear();
        int nTranslatableAfter = this.count(this.UNJOINED_SUBCLASSES);
        int nTranslationAfter = this.count((Class)Translation.class);
        TestTablePerClassInheritanceWithAbstractRoot.assertEquals((int)(nTranslatableBefore + 3), (int)nTranslatableAfter);
        TestTablePerClassInheritanceWithAbstractRoot.assertEquals((int)(nTranslationBefore + 4), (int)nTranslationAfter);
        em.getTransaction().begin();
        List result = em.createQuery("SELECT p FROM Translation p").getResultList();
        TestTablePerClassInheritanceWithAbstractRoot.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        for (Translation translation : result) {
            TestTablePerClassInheritanceWithAbstractRoot.assertTrue((boolean)translation.getTranslatable().getTranslations().contains(translation));
        }
        em.getTransaction().rollback();
    }

    void linkConsistently(Translation translation, Translatable translatable) {
        translatable.addTranslation(translation);
        translation.setTranslatable(translatable);
    }

    public int count(Class c) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        return ((Number)em.createQuery("SELECT COUNT(p) FROM " + c.getSimpleName() + " p").getSingleResult()).intValue();
    }

    public int count(Class<?> ... classes) {
        int total = 0;
        for (Class<?> c : classes) {
            total += this.count((Class)c);
        }
        return total;
    }
}

