/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance.abstractjoinedappid;

import java.util.Arrays;
import java.util.Collection;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.abstractjoinedappid.RelationOwner;
import org.apache.openjpa.persistence.inheritance.abstractjoinedappid.Subclass;
import org.apache.openjpa.persistence.inheritance.abstractjoinedappid.Superclass;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestAbstractJoinedAppId
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(Superclass.class, Subclass.class, RelationOwner.class, DROP_TABLES);
        Subclass s = new Subclass();
        s.setId(99);
        s.setAttr1("supattr");
        s.setAttr2("subattr");
        RelationOwner ro = new RelationOwner();
        ro.setId(1);
        ro.setSupers(Arrays.asList(s));
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)ro);
        em.getTransaction().commit();
        em.close();
    }

    public void testTraverseRelation() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        RelationOwner ro = (RelationOwner)em.find(RelationOwner.class, (Object)1);
        TestAbstractJoinedAppId.assertNotNull((Object)ro);
        Collection<Superclass> supers = ro.getSupers();
        TestAbstractJoinedAppId.assertEquals((int)1, (int)supers.size());
        Superclass s = supers.iterator().next();
        TestAbstractJoinedAppId.assertTrue((boolean)(s instanceof Subclass));
        TestAbstractJoinedAppId.assertEquals((Object)new Integer(99), (Object)s.getId());
        TestAbstractJoinedAppId.assertEquals((String)"supattr", (String)s.getAttr1());
        TestAbstractJoinedAppId.assertEquals((String)"subattr", (String)((Subclass)s).getAttr2());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestAbstractJoinedAppId.class);
    }
}

