/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.NoGenEntityL3;
import org.apache.openjpa.persistence.inheritance.NoGenEntityL3Sibling;
import org.apache.openjpa.persistence.inheritance.NoGenMappedSuperclassBase;
import org.apache.openjpa.persistence.inheritance.NoGenMappedSuperclassL2;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSharedMappedSuperclassIdValue
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(CLEAR_TABLES, NoGenMappedSuperclassBase.class, NoGenMappedSuperclassL2.class, NoGenEntityL3.class, NoGenEntityL3Sibling.class);
        NoGenEntityL3 ent = new NoGenEntityL3();
        ent.setId(1L);
        ent.setL2Data(99);
        ent.setL3Data(100);
        NoGenEntityL3Sibling sib = new NoGenEntityL3Sibling();
        sib.setId(1L);
        sib.setL2Data(100);
        sib.setSiblingL3Data(101);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)ent);
        em.persist((Object)sib);
        em.getTransaction().commit();
        em.close();
    }

    public void testFind() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        NoGenEntityL3 ent = (NoGenEntityL3)em.find(NoGenEntityL3.class, (Object)1L);
        TestSharedMappedSuperclassIdValue.assertNotNull((Object)ent);
        TestSharedMappedSuperclassIdValue.assertEquals((int)99, (int)ent.getL2Data());
        TestSharedMappedSuperclassIdValue.assertEquals((int)100, (int)ent.getL3Data());
        NoGenEntityL3Sibling sib = (NoGenEntityL3Sibling)em.find(NoGenEntityL3Sibling.class, (Object)1L);
        TestSharedMappedSuperclassIdValue.assertNotNull((Object)sib);
        TestSharedMappedSuperclassIdValue.assertEquals((int)100, (int)sib.getL2Data());
        TestSharedMappedSuperclassIdValue.assertEquals((int)101, (int)sib.getSiblingL3Data());
        em.close();
    }

    public void testGetReference() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        NoGenEntityL3 ent = (NoGenEntityL3)em.getReference(NoGenEntityL3.class, (Object)1L);
        TestSharedMappedSuperclassIdValue.assertNotNull((Object)ent);
        NoGenEntityL3Sibling sib = (NoGenEntityL3Sibling)em.getReference(NoGenEntityL3Sibling.class, (Object)1L);
        TestSharedMappedSuperclassIdValue.assertNotNull((Object)sib);
        TestSharedMappedSuperclassIdValue.assertEquals((int)99, (int)ent.getL2Data());
        TestSharedMappedSuperclassIdValue.assertEquals((int)100, (int)ent.getL3Data());
        TestSharedMappedSuperclassIdValue.assertEquals((int)100, (int)sib.getL2Data());
        TestSharedMappedSuperclassIdValue.assertEquals((int)101, (int)sib.getSiblingL3Data());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestSharedMappedSuperclassIdValue.class);
    }
}

