/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.inheritance;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.inheritance.entity.Admin;
import org.apache.openjpa.persistence.inheritance.entity.ComputerUser;
import org.apache.openjpa.persistence.inheritance.entity.RegularUser;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestIdentityWithSingleTableStrategy
extends SingleEMFTestCase {
    private Admin admin;
    private RegularUser user;

    public void setUp() {
        super.setUp(CLEAR_TABLES, Admin.class, RegularUser.class, ComputerUser.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.admin = new Admin();
        this.user = new RegularUser();
        this.user.setAdmin(this.admin);
        this.admin.addRegularUser(this.user);
        em.persist((Object)this.admin);
        em.persist((Object)this.user);
        em.getTransaction().commit();
        em.close();
    }

    public void tearDown() {
    }

    public void testFindAndNaviagtedEntityIdential() {
        Admin adminFromMethodBean;
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        RegularUser regularUserFromFind = (RegularUser)em1.find(RegularUser.class, (Object)this.user.getOid());
        Admin adminFromFind = (Admin)em1.find(Admin.class, (Object)this.admin.getOid());
        TestIdentityWithSingleTableStrategy.assertTrue((adminFromFind == (adminFromMethodBean = regularUserFromFind.getAdmin()) ? 1 : 0) != 0);
        em1.close();
    }

    public void testReferenceAndNaviagtedEntityIdential() {
        Admin adminFromMethodBean;
        OpenJPAEntityManagerSPI em1 = this.emf.createEntityManager();
        RegularUser regularUserFromFind = (RegularUser)em1.find(RegularUser.class, (Object)this.user.getOid());
        Admin adminFromGetReference = (Admin)em1.getReference(Admin.class, (Object)this.admin.getOid());
        TestIdentityWithSingleTableStrategy.assertTrue((adminFromGetReference == (adminFromMethodBean = regularUserFromFind.getAdmin()) ? 1 : 0) != 0);
        em1.close();
    }
}

