/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.identity.entityasidentity;

import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.identity.entityasidentity.Account;
import org.apache.openjpa.persistence.identity.entityasidentity.AccountGroup;
import org.apache.openjpa.persistence.identity.entityasidentity.AccountId;
import org.apache.openjpa.persistence.identity.entityasidentity.Person;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEntityAsIdentityFields
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(Account.class, AccountGroup.class, Person.class, "openjpa.Compatibility", "reorderMetaDataResolution=true");
    }

    public void testEntityAsIdentityField001() {
        OpenJPAEntityManagerSPI em = null;
        em = this.emf.createEntityManager();
        Query query = em.createQuery("SELECT ag from AccountGroup ag");
        List resultList = query.getResultList();
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntityAsIdentityField002A() {
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            this.createPopulation((EntityManager)em);
            em.clear();
            AccountId aId = new AccountId();
            aId.setAccountId(1);
            aId.setAccountHolder(1);
            aId.setGroupId(1);
            Account findAccount = (Account)em.find(Account.class, (Object)aId);
            TestEntityAsIdentityFields.assertTrue((findAccount != null ? 1 : 0) != 0);
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntityAsIdentityField002B() {
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            this.createPopulation((EntityManager)em);
            AccountId aId = new AccountId();
            aId.setAccountId(1);
            aId.setAccountHolder(1);
            aId.setGroupId(1);
            Account findAccount = (Account)em.find(Account.class, (Object)aId);
            TestEntityAsIdentityFields.assertTrue((findAccount != null ? 1 : 0) != 0);
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntityAsIdentityField002C() {
        OpenJPAEntityManagerSPI em = null;
        OpenJPAEntityManagerSPI emPop = null;
        try {
            emPop = this.emf.createEntityManager();
            em = this.emf.createEntityManager();
            this.createPopulation((EntityManager)emPop);
            em.clear();
            AccountId aId = new AccountId();
            aId.setAccountId(1);
            aId.setAccountHolder(1);
            aId.setGroupId(1);
            Account findAccount = (Account)em.find(Account.class, (Object)aId);
            TestEntityAsIdentityFields.assertTrue((findAccount != null ? 1 : 0) != 0);
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            if (emPop != null) {
                if (emPop.getTransaction().isActive()) {
                    emPop.getTransaction().rollback();
                }
                emPop.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntityAsIdentityField003A() {
        OpenJPAEntityManagerSPI em = null;
        try {
            em = this.emf.createEntityManager();
            this.createPopulation((EntityManager)em);
            em.clear();
            Query query = em.createQuery("SELECT a FROM Account a WHERE a.accountHolder.id > 5");
            List resultList = query.getResultList();
            TestEntityAsIdentityFields.assertEquals((int)5, (int)resultList.size());
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEntityAsIdentityField004A() {
        OpenJPAEntityManagerSPI em = null;
        OpenJPAEntityManagerSPI emPop = null;
        try {
            emPop = this.emf.createEntityManager();
            em = this.emf.createEntityManager();
            this.createPopulation((EntityManager)emPop);
            em.clear();
            Query query = em.createQuery("SELECT a FROM Account a WHERE a.accountHolder.id > 5");
            List resultList = query.getResultList();
            TestEntityAsIdentityFields.assertEquals((int)5, (int)resultList.size());
        }
        finally {
            if (em != null) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            if (emPop != null) {
                if (emPop.getTransaction().isActive()) {
                    emPop.getTransaction().rollback();
                }
                emPop.close();
            }
        }
    }

    private void createPopulation(EntityManager em) {
        em.getTransaction().begin();
        AccountGroup ag = new AccountGroup();
        ag.setId(1);
        Set<Account> agAccountSet = ag.getAccountSet();
        em.persist((Object)ag);
        for (int index = 1; index <= 10; ++index) {
            Person peep = new Person();
            peep.setId(index);
            peep.setFirstName("John");
            peep.setLastName("Doe");
            Account account = new Account();
            account.setAccountId(index);
            account.setAccountHolder(peep);
            account.setGroupId(index / 5 + 1);
            account.setBalanceInCents(0);
            account.setBalanceInDollars(index * 1000);
            em.persist((Object)peep);
            em.persist((Object)account);
            agAccountSet.add(account);
        }
        em.getTransaction().commit();
    }
}

