/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.identity;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.persistence.identity.StringIdEntity;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestStringId
extends AbstractPersistenceTestCase {
    private static EntityManagerFactory _emf;

    public void setUp() {
        _emf = this.createEMF(StringIdEntity.class);
        this.cleanup();
    }

    public void tearDown() {
        _emf.close();
    }

    private void cleanup() {
        EntityManager em = _emf.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("Delete from StringIdEntity").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    public void testTrailingWhitespace() {
        StringIdEntity sie1 = new StringIdEntity();
        sie1.setId("ABC ");
        EntityManager em = _emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)sie1);
        em.getTransaction().commit();
        TestStringId.assertTrue((boolean)em.contains((Object)sie1));
        StringIdEntity sie2 = (StringIdEntity)em.find(StringIdEntity.class, (Object)"ABC");
        TestStringId.assertSame((String)"Find should return the same instance with trailing whitespace", (Object)sie1, (Object)sie2);
        StringIdEntity sie3 = (StringIdEntity)em.find(StringIdEntity.class, (Object)"ABC  ");
        TestStringId.assertSame((String)"Find should return the same instance with trailing whitespace", (Object)sie1, (Object)sie3);
        TestStringId.assertNotSame((String)"Leading WS should not match", (Object)sie1, (Object)em.find(StringIdEntity.class, (Object)" ABC"));
        em.close();
    }

    public void testLeadingWhitespace() {
        StringIdEntity sie1 = new StringIdEntity();
        sie1.setId(" ABC");
        EntityManager em = _emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)sie1);
        em.getTransaction().commit();
        TestStringId.assertTrue((boolean)em.contains((Object)sie1));
        StringIdEntity sie2 = (StringIdEntity)em.find(StringIdEntity.class, (Object)"ABC");
        TestStringId.assertNotSame((String)"Find should not return the same instance with leading whitespace", (Object)sie1, (Object)sie2);
        StringIdEntity sie3 = (StringIdEntity)em.find(StringIdEntity.class, (Object)"   ABC");
        TestStringId.assertNotSame((String)"Find should not return the same instance with leading whitespace", (Object)sie1, (Object)sie3);
        TestStringId.assertSame((Object)sie1, (Object)em.find(StringIdEntity.class, (Object)" ABC"));
        TestStringId.assertNotSame((String)"Trailing WS should not match", (Object)sie1, (Object)em.find(StringIdEntity.class, (Object)"ABC "));
        em.close();
    }

    public void testInnerWhitespace() {
        StringIdEntity sie1 = new StringIdEntity();
        sie1.setId("A B C");
        EntityManager em = _emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)sie1);
        em.getTransaction().commit();
        TestStringId.assertTrue((boolean)em.contains((Object)sie1));
        StringIdEntity sie2 = (StringIdEntity)em.find(StringIdEntity.class, (Object)"ABC");
        TestStringId.assertNotSame((String)"Find should not return the same instance with inner whitespace", (Object)sie1, (Object)sie2);
        StringIdEntity sie3 = (StringIdEntity)em.find(StringIdEntity.class, (Object)"   ABC");
        TestStringId.assertNotSame((String)"Find should not return the same instance with inner whitespace", (Object)sie1, (Object)sie3);
        TestStringId.assertSame((Object)sie1, (Object)em.find(StringIdEntity.class, (Object)"A B C"));
        TestStringId.assertNotSame((String)"Trailing WS should not match", (Object)sie1, (Object)em.find(StringIdEntity.class, (Object)"ABC "));
        em.close();
    }
}

