/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.identity;

import java.math.BigDecimal;
import java.math.BigInteger;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.identity.SQLBigIntegerIdEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSQLBigIntegerId
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(SQLBigIntegerIdEntity.class, CLEAR_TABLES);
    }

    public void testPersist() {
        long time = System.currentTimeMillis() / 1000L * 1000L;
        BigInteger integer = new BigDecimal(time).toBigInteger();
        SQLBigIntegerIdEntity e = new SQLBigIntegerIdEntity();
        e.setId(integer);
        e.setData(1);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e);
        em.getTransaction().commit();
        TestSQLBigIntegerId.assertEquals((long)time, (long)e.getId().longValue());
        em.close();
        em = this.emf.createEntityManager();
        e = (SQLBigIntegerIdEntity)em.find(SQLBigIntegerIdEntity.class, (Object)integer);
        TestSQLBigIntegerId.assertEquals((int)1, (int)e.getData());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestSQLBigIntegerId.class);
    }
}

