/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.identity;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.identity.DoubleObjIdEntity;
import org.apache.openjpa.persistence.identity.FloatIdEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestFloatingPointIds
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(FloatIdEntity.class, DoubleObjIdEntity.class);
    }

    public void testPersistFloat() {
        FloatIdEntity e = new FloatIdEntity();
        e.setId(3.0f);
        e.setData(33);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e);
        em.getTransaction().commit();
        TestFloatingPointIds.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(e.getId()));
        em.close();
        em = this.emf.createEntityManager();
        e = (FloatIdEntity)em.find(FloatIdEntity.class, (Object)Float.valueOf(3.0f));
        TestFloatingPointIds.assertEquals((int)33, (int)e.getData());
        em.close();
    }

    public void testPersistDoubleObj() {
        DoubleObjIdEntity e = new DoubleObjIdEntity();
        e.setId(new Double(4.0));
        e.setData(44);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e);
        em.getTransaction().commit();
        TestFloatingPointIds.assertEquals((Object)new Double(4.0), (Object)e.getId());
        em.close();
        em = this.emf.createEntityManager();
        e = (DoubleObjIdEntity)em.find(DoubleObjIdEntity.class, (Object)new Double(4.0));
        TestFloatingPointIds.assertEquals((int)44, (int)e.getData());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestFloatingPointIds.class);
    }
}

