/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.generationtype;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.generationtype.EntityE2;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestNativeSeqGenerator
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    JDBCConfiguration conf;
    DBDictionary dict;
    boolean supportsNativeSequence = false;
    EntityE2 entityE2;

    public void setUp() throws Exception {
        super.setUp(EntityE2.class, DROP_TABLES);
        TestNativeSeqGenerator.assertNotNull((Object)this.emf);
        this.conf = (JDBCConfiguration)this.emf.getConfiguration();
        this.dict = this.conf.getDBDictionaryInstance();
        boolean bl = this.supportsNativeSequence = this.dict.nextSequenceQuery != null;
        if (this.supportsNativeSequence) {
            this.em = this.emf.createEntityManager();
            TestNativeSeqGenerator.assertNotNull((Object)this.em);
        }
    }

    public void createEntityE2() {
        this.entityE2 = new EntityE2("e name");
    }

    public void testGetIdGeneratorSeqGen() {
        if (!this.supportsNativeSequence) {
            System.out.println("Does not support native sequence");
            return;
        }
        this.createEntityE2();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityE2);
        this.em.getTransaction().commit();
        int genId = this.entityE2.getId();
        int nextId = (int)((Long)this.em.getIdGenerator(EntityE2.class).next()).longValue();
        TestNativeSeqGenerator.assertTrue((String)"Next value should depend on previous genid", (nextId == genId + 1 ? 1 : 0) != 0);
        this.em.close();
    }
}

