/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.generationtype;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.H2Dictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.generationtype.Dog1;
import org.apache.openjpa.persistence.generationtype.Dog2;
import org.apache.openjpa.persistence.generationtype.Dog3;
import org.apache.openjpa.persistence.generationtype.Dog4;
import org.apache.openjpa.persistence.generationtype.DogTable;
import org.apache.openjpa.persistence.generationtype.DogTable2;
import org.apache.openjpa.persistence.generationtype.DogTable3;
import org.apache.openjpa.persistence.generationtype.DogTable4;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultipleSchemaNames
extends SingleEMFTestCase {
    public void setUp() {
        this.setUnsupportedDatabases(MySQLDictionary.class, OracleDictionary.class, SQLServerDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        if ("testGeneratedAUTO".equals(this.getName())) {
            this.createSchemas();
        }
        this.setUp(Dog1.class, Dog2.class, Dog3.class, Dog4.class, DogTable.class, DogTable2.class, DogTable3.class, DogTable4.class);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Query qry = em.createQuery("select d from Dog1 d");
        List result = qry.getResultList();
        for (int index = 0; index < result.size(); ++index) {
            Dog1 Obj = (Dog1)result.get(index);
            em.remove((Object)Obj);
        }
        Query qry2 = em.createQuery("select d from Dog2 d");
        List result2 = qry2.getResultList();
        for (int index = 0; index < result2.size(); ++index) {
            Dog2 Obj = (Dog2)result2.get(index);
            em.remove((Object)Obj);
        }
        Query qry3 = em.createQuery("select d from DogTable d");
        List result3 = qry3.getResultList();
        for (int index = 0; index < result3.size(); ++index) {
            DogTable Obj = (DogTable)result3.get(index);
            em.remove((Object)Obj);
        }
        Query qry4 = em.createQuery("select d from DogTable2 d");
        List result4 = qry4.getResultList();
        for (int index = 0; index < result4.size(); ++index) {
            DogTable2 Obj = (DogTable2)result4.get(index);
            em.remove((Object)Obj);
        }
        Query qry5 = em.createQuery("select d from DogTable3 d");
        List result5 = qry5.getResultList();
        for (int index = 0; index < result5.size(); ++index) {
            DogTable3 Obj = (DogTable3)result5.get(index);
            em.remove((Object)Obj);
        }
        Query qry6 = em.createQuery("select d from DogTable4 d");
        List result6 = qry6.getResultList();
        for (int index = 0; index < result6.size(); ++index) {
            DogTable4 Obj = (DogTable4)result6.get(index);
            em.remove((Object)Obj);
        }
        Query qry7 = em.createQuery("select d from Dog3 d");
        List result7 = qry7.getResultList();
        for (int index = 0; index < result7.size(); ++index) {
            Dog3 Obj = (Dog3)result7.get(index);
            em.remove((Object)Obj);
        }
        Query qry8 = em.createQuery("select d from Dog4 d");
        List result8 = qry8.getResultList();
        for (int index = 0; index < result8.size(); ++index) {
            Dog4 Obj = (Dog4)result8.get(index);
            em.remove((Object)Obj);
        }
        Query delschema1 = em.createNativeQuery("delete from schema1.openjpa_sequence_table");
        delschema1.executeUpdate();
        Query delschema2 = em.createNativeQuery("delete from schema2.openjpa_sequence_table");
        delschema2.executeUpdate();
        Query delgentable = em.createNativeQuery("delete from schema1.id_gen1");
        delgentable.executeUpdate();
        Query delgentable2 = em.createNativeQuery("delete from schema2.id_gen2");
        delgentable2.executeUpdate();
        Query delgentable3 = em.createNativeQuery("delete from schema3g.id_gen3");
        delgentable3.executeUpdate();
        Query delgentable4 = em.createNativeQuery("delete from schema4g.id_gen4");
        delgentable4.executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    public void testGeneratedAUTO() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        em.getTransaction().begin();
        Dog1 dog1 = new Dog1();
        dog1.setName("helloDog1");
        dog1.setPrice(12000.0f);
        em.persist((Object)dog1);
        Dog1 dog1a = new Dog1();
        dog1a.setName("helloDog2");
        dog1a.setPrice(22000.0f);
        em.persist((Object)dog1a);
        Dog2 dog2 = new Dog2();
        dog2.setName("helloDog3");
        dog2.setPrice(15000.0f);
        em.persist((Object)dog2);
        Dog2 dog2a = new Dog2();
        dog2a.setName("helloDog4");
        dog2a.setPrice(25000.0f);
        em.persist((Object)dog2a);
        em.getTransaction().commit();
        Dog1 dog1x = (Dog1)em.find(Dog1.class, kem.getObjectId((Object)dog1));
        TestMultipleSchemaNames.assertTrue((dog1x.getId2() == 1 || dog1x.getId2() == 2 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog1x.getName(), (String)"helloDog1");
        dog1x.setName("Dog1");
        dog1x.setDomestic(true);
        Dog1 dog11 = (Dog1)em.find(Dog1.class, kem.getObjectId((Object)dog1a));
        TestMultipleSchemaNames.assertTrue((dog11.getId2() == 1 || dog11.getId2() == 2 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog11.getName(), (String)"helloDog2");
        dog11.setName("Dog2");
        dog11.setDomestic(true);
        Dog2 dog2x = (Dog2)em.find(Dog2.class, kem.getObjectId((Object)dog2));
        TestMultipleSchemaNames.assertTrue((dog2x.getId2() == 1 || dog2x.getId2() == 2 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog2x.getName(), (String)"helloDog3");
        dog2x.setName("Dog3");
        dog2x.setDomestic(true);
        Dog2 dog21 = (Dog2)em.find(Dog2.class, kem.getObjectId((Object)dog2a));
        TestMultipleSchemaNames.assertTrue((dog21.getId2() == 1 || dog21.getId2() == 2 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog21.getName(), (String)"helloDog4");
        dog21.setName("Dog4");
        dog21.setDomestic(true);
        em.getTransaction().begin();
        Query qry1 = em.createQuery("select d from Dog1 d order by d.name");
        List result1 = qry1.getResultList();
        for (int index = 0; index < result1.size(); ++index) {
            Dog1 dog4 = (Dog1)result1.get(index);
            int i = index + 1;
            TestMultipleSchemaNames.assertTrue((dog4.getId2() == 1 || dog4.getId2() == 2 ? 1 : 0) != 0);
            TestMultipleSchemaNames.assertEquals((String)dog4.getName(), (String)("Dog" + i));
        }
        Query qry2 = em.createQuery("select d from Dog2 d order by d.name");
        List result2 = qry2.getResultList();
        for (int index = 0; index < result2.size(); ++index) {
            Dog2 dog5 = (Dog2)result2.get(index);
            TestMultipleSchemaNames.assertTrue((dog5.getId2() == 1 || dog5.getId2() == 2 ? 1 : 0) != 0);
            int j = index + 3;
            TestMultipleSchemaNames.assertEquals((String)dog5.getName(), (String)("Dog" + j));
        }
        em.getTransaction().commit();
        em.close();
    }

    public void testGeneratedTABLE() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        em.getTransaction().begin();
        DogTable dog1 = new DogTable();
        dog1.setName("helloDog1");
        dog1.setPrice(12000.0f);
        em.persist((Object)dog1);
        DogTable dog1a = new DogTable();
        dog1a.setName("helloDog2");
        dog1a.setPrice(22000.0f);
        em.persist((Object)dog1a);
        DogTable2 dog2 = new DogTable2();
        dog2.setName("helloDog3");
        dog2.setPrice(15000.0f);
        em.persist((Object)dog2);
        DogTable2 dog2a = new DogTable2();
        dog2a.setName("helloDog4");
        dog2a.setPrice(25000.0f);
        em.persist((Object)dog2a);
        DogTable3 dog3 = new DogTable3();
        dog3.setName("helloDog5");
        dog3.setPrice(15001.0f);
        em.persist((Object)dog3);
        DogTable3 dog3a = new DogTable3();
        dog3a.setName("helloDog6");
        dog3a.setPrice(25001.0f);
        em.persist((Object)dog3a);
        DogTable4 dog4 = new DogTable4();
        dog4.setName("helloDog7");
        dog4.setPrice(15002.0f);
        em.persist((Object)dog4);
        DogTable4 dog4a = new DogTable4();
        dog4a.setName("helloDog8");
        dog4a.setPrice(25002.0f);
        em.persist((Object)dog4a);
        em.getTransaction().commit();
        DogTable dog1x = (DogTable)em.find(DogTable.class, kem.getObjectId((Object)dog1));
        TestMultipleSchemaNames.assertTrue((dog1x.getId2() == 20 || dog1x.getId2() == 21 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog1x.getName(), (String)"helloDog1");
        dog1x.setName("Dog1");
        dog1x.setDomestic(true);
        DogTable dog11 = (DogTable)em.find(DogTable.class, kem.getObjectId((Object)dog1a));
        TestMultipleSchemaNames.assertTrue((dog11.getId2() == 20 || dog11.getId2() == 21 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog11.getName(), (String)"helloDog2");
        dog11.setName("Dog2");
        dog11.setDomestic(true);
        DogTable2 dog2x = (DogTable2)em.find(DogTable2.class, kem.getObjectId((Object)dog2));
        TestMultipleSchemaNames.assertTrue((dog2x.getId2() == 100 || dog2x.getId2() == 101 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog2x.getName(), (String)"helloDog3");
        dog2x.setName("Dog3");
        dog2x.setDomestic(true);
        DogTable2 dog21 = (DogTable2)em.find(DogTable2.class, kem.getObjectId((Object)dog2a));
        TestMultipleSchemaNames.assertTrue((dog21.getId2() == 100 || dog21.getId2() == 101 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog21.getName(), (String)"helloDog4");
        dog21.setName("Dog4");
        dog21.setDomestic(true);
        DogTable3 dog3x = (DogTable3)em.find(DogTable3.class, kem.getObjectId((Object)dog3));
        TestMultipleSchemaNames.assertTrue((dog3x.getId2() == 100 || dog3x.getId2() == 101 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog3x.getName(), (String)"helloDog5");
        dog3x.setName("Dog5");
        dog3x.setDomestic(true);
        DogTable3 dog31 = (DogTable3)em.find(DogTable3.class, kem.getObjectId((Object)dog3a));
        TestMultipleSchemaNames.assertTrue((dog31.getId2() == 100 || dog31.getId2() == 101 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog31.getName(), (String)"helloDog6");
        dog31.setName("Dog6");
        dog31.setDomestic(true);
        DogTable4 dog4x = (DogTable4)em.find(DogTable4.class, kem.getObjectId((Object)dog4));
        TestMultipleSchemaNames.assertTrue((dog4x.getId2() == 100 || dog4x.getId2() == 101 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog4x.getName(), (String)"helloDog7");
        dog4x.setName("Dog7");
        dog4x.setDomestic(true);
        DogTable4 dog41 = (DogTable4)em.find(DogTable4.class, kem.getObjectId((Object)dog4a));
        TestMultipleSchemaNames.assertTrue((dog41.getId2() == 100 || dog41.getId2() == 101 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog41.getName(), (String)"helloDog8");
        dog41.setName("Dog8");
        dog41.setDomestic(true);
        em.getTransaction().begin();
        Query qry1 = em.createQuery("select d from DogTable d order by d.name");
        List result1 = qry1.getResultList();
        for (int index = 0; index < result1.size(); ++index) {
            DogTable dog1xx = (DogTable)result1.get(index);
            TestMultipleSchemaNames.assertTrue((dog1xx.getId2() == 20 || dog1xx.getId2() == 21 ? 1 : 0) != 0);
            int j = index + 1;
            TestMultipleSchemaNames.assertEquals((String)dog1xx.getName(), (String)("Dog" + j));
        }
        Query qry2 = em.createQuery("select d from DogTable2 d order by d.name");
        List result2 = qry2.getResultList();
        for (int index = 0; index < result2.size(); ++index) {
            DogTable2 dog2xx = (DogTable2)result2.get(index);
            TestMultipleSchemaNames.assertTrue((dog2xx.getId2() == 100 || dog2xx.getId2() == 101 ? 1 : 0) != 0);
            int j = index + 3;
            TestMultipleSchemaNames.assertEquals((String)dog2xx.getName(), (String)("Dog" + j));
        }
        Query qry3 = em.createQuery("select d from DogTable3 d order by d.name");
        List result3 = qry3.getResultList();
        for (int index = 0; index < result3.size(); ++index) {
            DogTable3 dog3xx = (DogTable3)result3.get(index);
            TestMultipleSchemaNames.assertTrue((dog3xx.getId2() == 100 || dog3xx.getId2() == 101 ? 1 : 0) != 0);
            int j = index + 5;
            TestMultipleSchemaNames.assertEquals((String)dog3xx.getName(), (String)("Dog" + j));
        }
        Query qry4 = em.createQuery("select d from DogTable4 d order by d.name");
        List result4 = qry4.getResultList();
        for (int index = 0; index < result4.size(); ++index) {
            DogTable4 dog4xx = (DogTable4)result4.get(index);
            TestMultipleSchemaNames.assertTrue((dog4xx.getId2() == 100 || dog4xx.getId2() == 101 ? 1 : 0) != 0);
            int j = index + 7;
            TestMultipleSchemaNames.assertEquals((String)dog4xx.getName(), (String)("Dog" + j));
        }
        em.getTransaction().commit();
        em.close();
    }

    public void testGeneratedIDENTITY() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        em.getTransaction().begin();
        Dog3 dog30 = new Dog3();
        dog30.setName("Dog30");
        em.persist((Object)dog30);
        Dog3 dog31 = new Dog3();
        dog31.setName("Dog31");
        em.persist((Object)dog31);
        em.getTransaction().commit();
        Dog3 dog30x = (Dog3)em.find(Dog3.class, kem.getObjectId((Object)dog30));
        Dog3 dog31x = (Dog3)em.find(Dog3.class, kem.getObjectId((Object)dog31));
        TestMultipleSchemaNames.assertTrue((dog30x.getId() + 1 == dog31x.getId() || dog30x.getId() == dog31x.getId() + 1 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog30x.getName(), (String)"Dog30");
        em.getTransaction().begin();
        Dog4 dog40 = new Dog4();
        dog40.setName("Dog40");
        em.persist((Object)dog40);
        Dog4 dog41 = new Dog4();
        dog41.setName("Dog41");
        em.persist((Object)dog41);
        em.getTransaction().commit();
        Dog4 dog40x = (Dog4)em.find(Dog4.class, kem.getObjectId((Object)dog40));
        Dog4 dog41x = (Dog4)em.find(Dog4.class, kem.getObjectId((Object)dog41));
        TestMultipleSchemaNames.assertTrue((dog40x.getId() + 1 == dog41x.getId() || dog40x.getId() == dog41x.getId() + 1 ? 1 : 0) != 0);
        TestMultipleSchemaNames.assertEquals((String)dog40x.getName(), (String)"Dog40");
        em.close();
    }

    private void createSchemas() {
        String[] schemas;
        OpenJPAEntityManagerFactorySPI tempEmf = this.createEMF(new Object[0]);
        DBDictionary dict = ((JDBCConfiguration)tempEmf.getConfiguration()).getDBDictionaryInstance();
        if (!(dict instanceof PostgresDictionary) && !(dict instanceof H2Dictionary)) {
            this.closeEMF((EntityManagerFactory)tempEmf);
            return;
        }
        OpenJPAEntityManagerSPI em = tempEmf.createEntityManager();
        for (String schema : schemas = new String[]{"SCHEMA1", "SCHEMA2", "SCHEMA3", "SCHEMA3G", "SCHEMA4G"}) {
            try {
                em.getTransaction().begin();
                OpenJPAQuery q = em.createNativeQuery("create schema " + schema);
                q.executeUpdate();
                em.getTransaction().commit();
            }
            catch (PersistenceException e) {
                em.getTransaction().rollback();
            }
        }
        this.closeEMF((EntityManagerFactory)tempEmf);
    }
}

