/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.generationtype;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.generationtype.EntityWithGeneratedValueAndPostPersist;
import org.apache.openjpa.persistence.generationtype.ValueCache;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestEntityWithGeneratedValueAndPostPersist
extends SingleEMFTestCase
implements ValueCache {
    private int cache;

    public void setUp() {
        this.setUp(EntityWithGeneratedValueAndPostPersist.class, CLEAR_TABLES);
        this.cache = 0;
    }

    public void setValue(int val) {
        this.cache = val;
    }

    public void testValueCapturedInPostPersistAfterCommit() {
        EntityManager em = this.getEM();
        em.getTransaction().begin();
        EntityWithGeneratedValueAndPostPersist pc = new EntityWithGeneratedValueAndPostPersist(1L);
        pc.setName("TestEntityWithGeneratedValueAndPostPersist-commit");
        pc.setCache(this);
        em.persist((Object)pc);
        em.getTransaction().commit();
        TestEntityWithGeneratedValueAndPostPersist.assertEquals((String)"Entity's current value does not match value captured in postPersist", (int)pc.getBingo(), (int)this.cache);
    }

    public void testValueCapturedInPostPersistAfterFlush() {
        EntityManager em = this.getEM();
        em.getTransaction().begin();
        EntityWithGeneratedValueAndPostPersist pc = new EntityWithGeneratedValueAndPostPersist(1L);
        pc.setName("TestEntityWithGeneratedValueAndPostPersist-flush");
        pc.setCache(this);
        em.persist((Object)pc);
        em.flush();
        TestEntityWithGeneratedValueAndPostPersist.assertEquals((String)"Entity's current value does not match value captured in postPersist", (int)pc.getBingo(), (int)this.cache);
        em.getTransaction().commit();
        TestEntityWithGeneratedValueAndPostPersist.assertEquals((String)"Entity's current value does not match value captured in postPersist", (int)pc.getBingo(), (int)this.cache);
    }

    private EntityManager getEM() {
        return this.emf.createEntityManager();
    }
}

