/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Version;
import org.apache.openjpa.persistence.Externalizer;
import org.apache.openjpa.persistence.Persistent;
import org.apache.openjpa.persistence.fields.SampleEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class EnumSetOwner {
    @Id
    private int id;
    @Version
    private int version;
    @Persistent
    @Externalizer(value="externalizer")
    private EnumSetHolder enumSetHolder;

    public Set<SampleEnum> getEnumSet() {
        return Collections.unmodifiableSet(this.enumSetHolder.enumSet);
    }

    public void setEnumSet(EnumSet<SampleEnum> enumSet) {
        this.enumSetHolder = new EnumSetHolder(enumSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSetHolder {
        private final EnumSet<SampleEnum> enumSet;

        public EnumSetHolder(String externalizedValue) {
            if (!"all".equals(externalizedValue)) {
                throw new IllegalStateException(externalizedValue);
            }
            this.enumSet = EnumSet.allOf(SampleEnum.class);
        }

        private EnumSetHolder(EnumSet<SampleEnum> enumSet) {
            this.enumSet = enumSet;
        }

        public String externalizer() {
            return "all";
        }
    }
}

