/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.fetchgroups;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.openjpa.persistence.fetchgroups.FGAddress;
import org.apache.openjpa.persistence.fetchgroups.FGDepartment;
import org.apache.openjpa.persistence.fetchgroups.FGEmployee;
import org.apache.openjpa.persistence.fetchgroups.FGManager;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestFetchGroupStacks
extends SingleEMTestCase {
    public void setUp() {
        this.setUp(FGManager.class, FGDepartment.class, FGEmployee.class, FGAddress.class);
    }

    public void testFetchGroupStacks() {
        this.assertFetchGroups(new String[0]);
        this.em.getFetchPlan().addFetchGroup("foo");
        this.assertFetchGroups("foo");
        this.em.pushFetchPlan().addFetchGroup("bar");
        this.assertFetchGroups("foo", "bar");
        this.em.pushFetchPlan().addFetchGroup("baz");
        this.assertFetchGroups("foo", "bar", "baz");
        this.em.pushFetchPlan().addFetchGroups(new String[]{"quux", "foo"});
        this.assertFetchGroups("foo", "bar", "baz", "quux");
        this.em.popFetchPlan();
        this.assertFetchGroups("foo", "bar", "baz");
        this.em.popFetchPlan();
        this.assertFetchGroups("foo", "bar");
        this.em.popFetchPlan();
        this.assertFetchGroups("foo");
        try {
            this.em.popFetchPlan();
            TestFetchGroupStacks.fail((String)"should be unbalanced");
        }
        catch (RuntimeException e) {
            TestFetchGroupStacks.assertTrue((boolean)e.getMessage().contains("stack"));
        }
    }

    private void assertFetchGroups(String ... fgs) {
        HashSet<String> s = new HashSet<String>();
        if (fgs != null) {
            s.addAll(Arrays.asList(fgs));
        }
        s.add("default");
        TestFetchGroupStacks.assertEquals(s, (Object)this.em.getFetchPlan().getFetchGroups());
    }
}

