/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.fetchgroups;

import javax.persistence.Basic;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.LoadFetchGroup;
import org.apache.openjpa.persistence.fetchgroups.FGAddress;
import org.apache.openjpa.persistence.fetchgroups.FGDepartment;
import org.apache.openjpa.persistence.fetchgroups.FGManager;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="EMP_TYPE", discriminatorType=DiscriminatorType.INTEGER)
@DiscriminatorValue(value="0")
@FetchGroups(value={@FetchGroup(name="AddressFetchGroup", attributes={@FetchAttribute(name="address")}), @FetchGroup(name="RatingFetchGroup", attributes={@FetchAttribute(name="rating")}), @FetchGroup(name="ManagerFetchGroup1A", attributes={@FetchAttribute(name="manager", recursionDepth=1)}), @FetchGroup(name="ManagerFetchGroup1B", attributes={@FetchAttribute(name="manager", recursionDepth=-1)}), @FetchGroup(name="ManagerFetchGroup2", attributes={@FetchAttribute(name="manager", recursionDepth=2)}), @FetchGroup(name="DescFetchGroup", attributes={@FetchAttribute(name="description")}), @FetchGroup(name="DepartmentFetchGroup", attributes={@FetchAttribute(name="dept")}), @FetchGroup(name="AggregateEmployeeFetchGroup1", attributes={@FetchAttribute(name="dept"), @FetchAttribute(name="address"), @FetchAttribute(name="manager", recursionDepth=1)}), @FetchGroup(name="AggregateEmployeeFetchGroup2", fetchGroups={"AggregateEmployeeFetchGroup1"}), @FetchGroup(name="AggregateEmployeeFetchGroup3", fetchGroups={"DepartmentFetchGroup", "AddressFetchGroup", "ManagerFetchGroup1A"}), @FetchGroup(name="AggregateEmployeeFetchGroup4", attributes={@FetchAttribute(name="dept"), @FetchAttribute(name="address")}, fetchGroups={"ManagerFetchGroup1A"})})
public class FGEmployee {
    @Id
    private int id;
    private String lastName;
    private String firstName;
    @Basic(fetch=FetchType.LAZY)
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    private FGDepartment dept;
    @OneToOne(fetch=FetchType.LAZY)
    private FGAddress address;
    @ManyToOne(fetch=FetchType.LAZY)
    private FGManager manager;
    @Basic(fetch=FetchType.LAZY)
    @LoadFetchGroup(value="AddressFetchGroup")
    private String rating;

    public FGEmployee() {
    }

    public FGEmployee(int id, String firstName, String lastName, String desc, FGDepartment dept, FGAddress address, FGManager manager, String rating) {
        this.id = id;
        this.lastName = lastName;
        this.firstName = firstName;
        this.description = desc;
        this.dept = dept;
        this.address = address;
        this.manager = manager;
        this.rating = rating;
    }

    public FGAddress getAddress() {
        return this.address;
    }

    public void setAddress(FGAddress address) {
        this.address = address;
    }

    public FGDepartment getDept() {
        return this.dept;
    }

    public void setDept(FGDepartment dept) {
        this.dept = dept;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public FGManager getManager() {
        return this.manager;
    }

    public void setManager(FGManager manager) {
        this.manager = manager;
    }

    public String getRating() {
        return this.rating;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public String toString() {
        return new String(this.getClass().getSimpleName() + "(id=" + this.id + ")");
    }
}

