/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.exception;

import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.exception.PObject;
import org.apache.openjpa.persistence.test.PersistenceTestCase;

public class TestParameterLogging
extends PersistenceTestCase {
    String _regex = ".*params=.*1,.*]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RollbackException getRollbackException(Object ... props) {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(props);
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        PObject p1 = new PObject();
        PObject p2 = new PObject();
        p1.setId(1L);
        p2.setId(1L);
        try {
            tran.begin();
            em.persist((Object)p1);
            em.persist((Object)p2);
            tran.commit();
            em.close();
            TestParameterLogging.fail((String)"Expected a RollbackException");
            RollbackException rollbackException = null;
            return rollbackException;
        }
        catch (RollbackException re) {
            RollbackException rollbackException = re;
            return rollbackException;
        }
        finally {
            if (tran.isActive()) {
                tran.rollback();
            }
            if (em.isOpen()) {
                em.close();
            }
            if (emf.isOpen()) {
                emf.close();
            }
        }
    }

    public void testNoParamsByDefault() {
        RollbackException e = this.getRollbackException(PObject.class, CLEAR_TABLES);
        TestParameterLogging.assertFalse((boolean)Pattern.matches(this._regex, e.toString()));
        for (Throwable nested = e.getCause(); nested != null; nested = nested.getCause()) {
            if (!Pattern.matches(".*INSERT.*", nested.toString())) continue;
            TestParameterLogging.assertFalse((boolean)Pattern.matches(this._regex, nested.toString()));
        }
    }

    public void testParamsEnabledByConfig() {
        Throwable nested;
        RollbackException e = this.getRollbackException(PObject.class, CLEAR_TABLES, "openjpa.ConnectionFactoryProperties", "PrintParameters=true");
        TestParameterLogging.assertFalse((boolean)Pattern.matches(this._regex, e.toString()));
        TestParameterLogging.assertNotNull((Object)nested);
        for (nested = e.getCause(); nested != null; nested = nested.getCause()) {
            if (!Pattern.matches(".*INSERT.*", nested.toString())) continue;
            TestParameterLogging.assertTrue((boolean)Pattern.matches(this._regex, nested.toString()));
        }
    }
}

