/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event.common.apps;

import javax.persistence.Entity;

@Entity
public class Duration
implements Cloneable {
    private String _name;
    private boolean _started;
    private boolean _running;
    private long _startTime;
    private long _stopTime;

    public Duration(String name) {
        this._name = name;
        this._started = false;
        this._running = false;
    }

    public String getName() {
        return this._name;
    }

    public synchronized void start() {
        if (this._started) {
            throw new RuntimeException("Duration was already started.");
        }
        this._startTime = System.currentTimeMillis();
        this._started = true;
        this._running = true;
    }

    public synchronized void stop() {
        if (!this._started) {
            throw new RuntimeException("Duration was never started.");
        }
        if (!this._running) {
            throw new RuntimeException("Duration was already stopped.");
        }
        this._stopTime = System.currentTimeMillis();
        this._running = false;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public synchronized Duration getCurrentDuration() {
        Duration currentDuration;
        if (!this._started) {
            throw new RuntimeException("Duration was never started.");
        }
        if (!this._running) {
            throw new RuntimeException("Duration is not running.");
        }
        long now = System.currentTimeMillis();
        try {
            currentDuration = (Duration)this.clone();
        }
        catch (Exception e) {
            currentDuration = new Duration("");
        }
        currentDuration._stopTime = now;
        currentDuration._running = false;
        return currentDuration;
    }

    public synchronized double getDurationAsSeconds() {
        if (!this._started) {
            throw new RuntimeException("Duration was never started.");
        }
        if (this._running) {
            Duration snapshot = this.getCurrentDuration();
            return 1000.0 * (double)(snapshot._stopTime - snapshot._startTime);
        }
        return (double)(this._stopTime - this._startTime) / 1000.0;
    }

    public synchronized boolean isRunning() {
        return this._running;
    }

    public synchronized boolean wasStarted() {
        return this._started;
    }

    public String toString() {
        double time = 0.0;
        StringBuffer buf = new StringBuffer(256);
        if (this.wasStarted()) {
            if (this.isRunning()) {
                Duration snapshot = this.getCurrentDuration();
                time = snapshot.getDurationAsSeconds();
            } else {
                time = this.getDurationAsSeconds();
            }
            buf.append("Duration for '" + this._name + "' is " + time + " (s).");
        } else {
            buf.append("Duration for '" + this._name + "' has not yet been started.");
        }
        return buf.toString();
    }
}

