/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManager;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.event.common.apps.Duration;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest1;

public class TestTCPRemoteClassChanges
extends AbstractTestCase {
    private static final int NUM_OBJECTS = 4;
    static int _fetchGroupSerial = 0;

    public TestTCPRemoteClassChanges(String s) {
        super(s, "eventcactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
    }

    public void tearDownTestClass() throws Exception {
    }

    private void pause(double seconds) {
        try {
            Thread.currentThread();
            Thread.yield();
            Thread.currentThread();
            Thread.sleep((int)seconds * 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAddedClasses() {
        OpenJPAEntityManagerFactory pmfSender = this.createDistinctFactory(TCPRemoteCommitProvider.class, "Port=5636, Addresses=127.0.0.1:5636;127.0.0.1:6636");
        OpenJPAEntityManagerFactory pmfReceiver = this.createDistinctFactory(TCPRemoteCommitProvider.class, "Port=6636, Addresses=127.0.0.1:6636;127.0.0.1:5636");
        RemoteCommitListenerTestImpl listenerAtReceiver = new RemoteCommitListenerTestImpl();
        ((OpenJPAEntityManagerFactorySPI)pmfReceiver).getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)listenerAtReceiver);
        OpenJPAEntityManager pmSender = pmfSender.createEntityManager();
        System.out.println("-------------------");
        System.out.println("2 PMFs created, acting as a cluster using ports 5636 and 6636");
        System.out.println("Testing scenario:");
        System.out.println("  - tx of inserts (normal trans)\n  - tx of inserts (large trans)\n  - tx of inserts,updates, dels (large trans)");
        System.out.println("Remote commit event will transmit classes.");
        this.performAdds((EntityManager)pmSender, 4);
        this.pause(1.0);
        TestTCPRemoteClassChanges.assertEquals((int)4, (int)listenerAtReceiver.totalAddedClasses);
        pmSender.setTrackChangesByType(true);
        this.performAdds((EntityManager)pmSender, 4);
        this.pause(1.0);
        TestTCPRemoteClassChanges.assertEquals((int)8, (int)listenerAtReceiver.totalAddedClasses);
        TestTCPRemoteClassChanges.assertEquals((int)0, (int)listenerAtReceiver.totalUpdatedClasses);
        TestTCPRemoteClassChanges.assertEquals((int)0, (int)listenerAtReceiver.totalDeletedClasses);
        TestTCPRemoteClassChanges.assertEquals((int)4, (int)listenerAtReceiver.receivedExtentEvCount);
        pmSender.setTrackChangesByType(true);
        this.performAddsModifiesDeletes((EntityManager)pmSender, 4);
        this.pause(1.0);
        TestTCPRemoteClassChanges.assertEquals((int)12, (int)listenerAtReceiver.totalAddedClasses);
        TestTCPRemoteClassChanges.assertEquals((int)4, (int)listenerAtReceiver.totalUpdatedClasses);
        TestTCPRemoteClassChanges.assertEquals((int)4, (int)listenerAtReceiver.totalDeletedClasses);
        TestTCPRemoteClassChanges.assertEquals((int)16, (int)listenerAtReceiver.receivedExtentEvCount);
        TestTCPRemoteClassChanges.assertEquals((int)0, (int)listenerAtReceiver.totalOidUpdated);
        TestTCPRemoteClassChanges.assertEquals((int)0, (int)listenerAtReceiver.totalOidDeleted);
        TestTCPRemoteClassChanges.assertEquals((int)0, (int)listenerAtReceiver.totalOidAdded);
        pmSender.close();
        pmfSender.close();
        pmfReceiver.close();
    }

    protected double performAdds(EntityManager pm, int numObjects) {
        int i;
        Duration timeToAMD = new Duration("Adds, " + numObjects + " objects.");
        timeToAMD.start();
        RuntimeTest1[] persistables = new RuntimeTest1[numObjects];
        for (i = 0; i < persistables.length; ++i) {
            persistables[i] = new RuntimeTest1("foo #" + i, i);
        }
        for (i = 0; i < persistables.length; ++i) {
            this.startTx(pm);
            pm.persist((Object)persistables[i]);
            this.endTx(pm);
        }
        timeToAMD.stop();
        return timeToAMD.getDurationAsSeconds();
    }

    protected void performAddsModifiesDeletes(EntityManager pm, int numObjects) {
        int i;
        RuntimeTest1[] persistables = new RuntimeTest1[numObjects];
        for (i = 0; i < persistables.length; ++i) {
            persistables[i] = new RuntimeTest1("foo #" + i, i);
        }
        for (i = 0; i < persistables.length; ++i) {
            this.startTx(pm);
            pm.persist((Object)persistables[i]);
            this.endTx(pm);
        }
        for (i = 0; i < persistables.length; ++i) {
            this.startTx(pm);
            persistables[i].setStringField("bazzed" + i);
            this.endTx(pm);
        }
        for (i = 0; i < persistables.length; ++i) {
            this.startTx(pm);
            pm.remove((Object)persistables[i]);
            this.endTx(pm);
        }
    }

    protected OpenJPAEntityManagerFactory createDistinctFactory(Class providerClass, String classProps1) {
        HashMap<String, String> propsMap;
        if (providerClass != null) {
            propsMap = new HashMap<String, String>();
            propsMap.put("openjpa.RemoteCommitProvider", Configurations.getPlugin((String)providerClass.getName(), (String)classProps1));
            propsMap.put("openjpa.FetchGroups", "differentiatingFetchGroup" + _fetchGroupSerial);
        } else {
            propsMap = new HashMap();
            propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
            propsMap.put("openjpa.FetchGroups", "differentiatingFetchGroup" + _fetchGroupSerial);
        }
        ++_fetchGroupSerial;
        return this.getEmf(propsMap);
    }

    protected static class RemoteCommitListenerTestImpl
    implements RemoteCommitListener {
        Collection updated;
        Collection deleted;
        int totalAddedClasses = 0;
        int totalUpdatedClasses = 0;
        int totalDeletedClasses = 0;
        int totalOidAdded = 0;
        int totalOidUpdated = 0;
        int totalOidDeleted = 0;
        int receivedExtentEvCount = 0;

        protected RemoteCommitListenerTestImpl() {
        }

        public synchronized void afterCommit(RemoteCommitEvent event) {
            this.totalAddedClasses += event.getPersistedTypeNames().size();
            if (event.getPayloadType() == 2) {
                ++this.receivedExtentEvCount;
                this.totalUpdatedClasses += event.getUpdatedTypeNames().size();
                this.totalDeletedClasses += event.getDeletedTypeNames().size();
            } else {
                if (event.getPayloadType() == 1) {
                    this.totalOidAdded = event.getPersistedObjectIds().size();
                }
                this.updated = event.getUpdatedObjectIds();
                this.deleted = event.getDeletedObjectIds();
                this.totalOidUpdated += this.updated.size();
                this.totalOidDeleted += this.deleted.size();
            }
        }

        public void resetCounts() {
            this.totalAddedClasses = 0;
            this.totalUpdatedClasses = 0;
            this.totalDeletedClasses = 0;
            this.totalOidAdded = 0;
            this.totalOidUpdated = 0;
            this.totalOidDeleted = 0;
        }

        public void close() {
        }

        public String toString() {
            String returnString = "Clsses add=" + this.totalAddedClasses + " dels=" + this.totalDeletedClasses + " ups=" + this.totalUpdatedClasses;
            returnString = returnString + "Oids add=" + this.totalAddedClasses + " dels=" + this.totalDeletedClasses + " ups=" + this.totalUpdatedClasses;
            return returnString;
        }
    }
}

