/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import org.apache.openjpa.jta.ContainerTest;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.event.PostRemoveCallbackEntity;

public class TestPostRemove
extends ContainerTest {
    public void setUp() throws Exception {
        super.setUp(PostRemoveCallbackEntity.class);
    }

    public String getPersistenceUnitName() {
        return "post-remove";
    }

    public void testPostRemoveInvokedOnlyAfterDatabaseDeleteWithLogicalFlush() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.joinTransaction();
        PostRemoveCallbackEntity pc = new PostRemoveCallbackEntity();
        em.persist((Object)pc);
        em.flush();
        em.remove((Object)pc);
        this.commit();
        TestPostRemove.assertTrue((String)"PostRemove not called after commit", (this.isPostRemovedInvoked(pc) && pc.getPostRemoveTime() <= System.nanoTime() ? 1 : 0) != 0);
    }

    public void testPostRemoveInvokedAfterDatabaseDeleteWithoutFlush() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.joinTransaction();
        PostRemoveCallbackEntity pc = new PostRemoveCallbackEntity();
        em.persist((Object)pc);
        em.remove((Object)pc);
        TestPostRemove.assertFalse((String)"PostRemove called before commit", (boolean)this.isPostRemovedInvoked(pc));
        this.commit();
        TestPostRemove.assertTrue((String)"PostRemove not called after commit", (pc.getPostRemoveTime() <= System.nanoTime() ? 1 : 0) != 0);
    }

    public void testPostRemoveNotInvokedAfterRollback() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.joinTransaction();
        PostRemoveCallbackEntity pc = new PostRemoveCallbackEntity();
        em.persist((Object)pc);
        em.remove((Object)pc);
        TestPostRemove.assertFalse((String)"PostRemove called before rollback", (boolean)this.isPostRemovedInvoked(pc));
        this.rollback();
        TestPostRemove.assertTrue((String)"PostRemove called after rollback", (pc.getPostRemoveTime() <= System.nanoTime() ? 1 : 0) != 0);
    }

    public void testPostRemoveNotInvokedAfterRollbackWithIntermediateFlush() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.joinTransaction();
        PostRemoveCallbackEntity pc = new PostRemoveCallbackEntity();
        em.persist((Object)pc);
        em.flush();
        TestPostRemove.assertFalse((String)"PostRemove called after flush", (boolean)this.isPostRemovedInvoked(pc));
        em.remove((Object)pc);
        TestPostRemove.assertFalse((String)"PostRemove called before rollback", (boolean)this.isPostRemovedInvoked(pc));
        this.rollback();
        TestPostRemove.assertTrue((String)"PostRemove called after rollback", (pc.getPostRemoveTime() <= System.nanoTime() ? 1 : 0) != 0);
    }

    public void testPostRemoveInvokedOnFlushThatIssuesDatabaseDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.joinTransaction();
        PostRemoveCallbackEntity pc = new PostRemoveCallbackEntity();
        em.persist((Object)pc);
        this.commit();
        em.close();
        em = this.emf.createEntityManager();
        em.joinTransaction();
        pc = (PostRemoveCallbackEntity)em.find(PostRemoveCallbackEntity.class, (Object)pc.getId());
        TestPostRemove.assertNotNull((Object)pc);
        em.remove((Object)pc);
        TestPostRemove.assertFalse((String)"PostRemove called after logical remove", (boolean)this.isPostRemovedInvoked(pc));
        em.flush();
        TestPostRemove.assertTrue((String)"PostRemove not called after delete flush", (boolean)this.isPostRemovedInvoked(pc));
        this.commit();
        TestPostRemove.assertTrue((String)"PostRemove not called after commit", (pc.getPostRemoveTime() <= System.nanoTime() ? 1 : 0) != 0);
    }

    public void testPostRemoveNotInvokedAfterDatabaseInsert() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.joinTransaction();
        PostRemoveCallbackEntity pc = new PostRemoveCallbackEntity();
        em.persist((Object)pc);
        TestPostRemove.assertFalse((String)"PostRemove called before commit", (boolean)this.isPostRemovedInvoked(pc));
        this.commit();
        TestPostRemove.assertFalse((String)"PostRemove called after commit", (boolean)this.isPostRemovedInvoked(pc));
    }

    boolean isPostRemovedInvoked(PostRemoveCallbackEntity pc) {
        return pc.getPostRemoveTime() != 0L;
    }
}

