/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.EntityNotFoundException;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.common.utils.BufferedLogFactory;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest1;
import org.apache.openjpa.util.OpenJPAException;

public class TestOrphanedKeyAction
extends AbstractTestCase {
    private Object _oid = null;

    public TestOrphanedKeyAction(String s) {
        super(s, "eventcactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        RuntimeTest1 pc = new RuntimeTest1();
        pc.setIntField(1);
        RuntimeTest1 pc2 = new RuntimeTest1();
        pc2.setIntField(2);
        pc.setSelfOneOne(pc2);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc);
        this.endTx((EntityManager)pm);
        this._oid = pm.getObjectId((Object)pc);
        this.startTx((EntityManager)pm);
        pm.remove((Object)pc2);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testLog() {
        Map map = this.getOrphanedKeyConfiguration("log(Level=FATAL)");
        OpenJPAEntityManagerFactory pmf = this.getEmf(map);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        BufferedLogFactory logFactory = (BufferedLogFactory)((OpenJPAEntityManagerSPI)pm).getConfiguration().getLogFactory();
        logFactory.clear();
        RuntimeTest1 pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
        logFactory.assertNoLogMessage("*orphan*");
        TestOrphanedKeyAction.assertNull((Object)pc.getSelfOneOne());
        logFactory.assertLogMessage("*orphan*");
        this.endEm((EntityManager)pm);
        pmf.close();
    }

    public void testException() {
        Map map = this.getOrphanedKeyConfiguration("exception");
        OpenJPAEntityManagerFactory pmf = this.getEmf(map);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        BufferedLogFactory logFactory = (BufferedLogFactory)((OpenJPAEntityManagerSPI)pm).getConfiguration().getLogFactory();
        logFactory.clear();
        RuntimeTest1 pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
        try {
            pc.getSelfOneOne();
            TestOrphanedKeyAction.fail((String)"Did not throw expected exception for orphaned key.");
        }
        catch (EntityNotFoundException onfe) {
            logFactory.assertNoLogMessage("*orphan*");
        }
        catch (OpenJPAException ke) {
            this.bug(1138, ke, "Wrong exception type.");
        }
        this.endEm((EntityManager)pm);
        pmf.close();
    }

    public void testNone() {
        Map map = this.getOrphanedKeyConfiguration("none");
        OpenJPAEntityManagerFactory pmf = this.getEmf(map);
        OpenJPAEntityManager pm = pmf.createEntityManager();
        BufferedLogFactory logFactory = (BufferedLogFactory)((OpenJPAEntityManagerSPI)pm).getConfiguration().getLogFactory();
        logFactory.clear();
        RuntimeTest1 pc = (RuntimeTest1)pm.find(RuntimeTest1.class, this._oid);
        TestOrphanedKeyAction.assertNull((Object)pc.getSelfOneOne());
        logFactory.assertNoLogMessage("*orphan*");
        this.endEm((EntityManager)pm);
        pmf.close();
    }

    Map getOrphanedKeyConfiguration(String orphanKeyAction) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.Log", BufferedLogFactory.class.getName());
        if (orphanKeyAction != null) {
            map.put("openjpa.OrphanedKeyAction", orphanKeyAction);
        }
        return map;
    }
}

