/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.event.AbstractRemoteCommitProvider;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest1;
import org.apache.openjpa.util.Id;

public class TestFakeRemoteEvents
extends AbstractTestCase {
    private static Object currentProviderLock = new Object();
    private static RemoteCommitProviderTestImpl currentProvider;

    public TestFakeRemoteEvents(String s) {
        super(s, "eventcactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
    }

    public void testListener() {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.DataCache", "true");
        OpenJPAEntityManagerFactory factory = this.getEmf(propsMap);
        RemoteCommitListenerTestImpl transactionListener = new RemoteCommitListenerTestImpl();
        ((OpenJPAEntityManagerFactorySPI)factory).getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)transactionListener);
        OpenJPAEntityManager pm = factory.createEntityManager();
        RuntimeTest1 t1 = new RuntimeTest1("foo", 5);
        this.startTx((EntityManager)pm);
        pm.persist((Object)t1);
        Object oid = pm.getObjectId((Object)t1);
        this.rollbackTx((EntityManager)pm);
        HashSet<Object> s = new HashSet<Object>();
        s.add(oid);
        ((OpenJPAEntityManagerFactorySPI)factory).getConfiguration().getRemoteCommitEventManager().fireEvent((Object)new RemoteCommitEvent(1, s, null, null, null));
        boolean pass = false;
        Iterator iter = transactionListener.added.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(oid)) continue;
            pass = true;
            break;
        }
        TestFakeRemoteEvents.assertTrue((boolean)pass);
        TestFakeRemoteEvents.assertTrue((transactionListener.updated.size() == 0 ? 1 : 0) != 0);
        TestFakeRemoteEvents.assertTrue((transactionListener.deleted.size() == 0 ? 1 : 0) != 0);
        ((OpenJPAEntityManagerFactorySPI)factory).getConfiguration().getRemoteCommitEventManager().fireEvent((Object)new RemoteCommitEvent(1, null, null, s, null));
        pass = false;
        iter = transactionListener.updated.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(oid)) continue;
            pass = true;
            break;
        }
        TestFakeRemoteEvents.assertTrue((boolean)pass);
        TestFakeRemoteEvents.assertTrue((transactionListener.added.size() == 0 ? 1 : 0) != 0);
        TestFakeRemoteEvents.assertTrue((transactionListener.deleted.size() == 0 ? 1 : 0) != 0);
        ((OpenJPAEntityManagerFactorySPI)factory).getConfiguration().getRemoteCommitEventManager().fireEvent((Object)new RemoteCommitEvent(1, null, null, null, s));
        pass = false;
        iter = transactionListener.deleted.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(oid)) continue;
            pass = true;
            break;
        }
        TestFakeRemoteEvents.assertTrue((boolean)pass);
        TestFakeRemoteEvents.assertTrue((transactionListener.added.size() == 0 ? 1 : 0) != 0);
        TestFakeRemoteEvents.assertTrue((transactionListener.updated.size() == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProvider() {
        RemoteCommitProviderTestImpl provider;
        OpenJPAEntityManager pm;
        Object object = currentProviderLock;
        synchronized (object) {
            HashMap<String, String> propsMap = new HashMap<String, String>();
            propsMap.put("openjpa.RemoteCommitProvider", RemoteCommitProviderTestImpl.class.getName() + "(TransmitPersistedObjectIds=true)");
            propsMap.put("openjpa.DataCache", "true");
            OpenJPAEntityManagerFactory factory = this.getEmf(propsMap);
            pm = factory.createEntityManager();
            provider = currentProvider;
        }
        RuntimeTest1 t1 = new RuntimeTest1("foo", 5);
        this.startTx((EntityManager)pm);
        pm.persist((Object)t1);
        Object oid = pm.getObjectId((Object)t1);
        this.endTx((EntityManager)pm);
        boolean pass = false;
        for (Object added : provider.added) {
            if (!this.equals(added, oid)) continue;
            pass = true;
            break;
        }
        TestFakeRemoteEvents.assertTrue((boolean)pass);
        TestFakeRemoteEvents.assertTrue((provider.updated.size() == 0 ? 1 : 0) != 0);
        TestFakeRemoteEvents.assertTrue((provider.deleted.size() == 0 ? 1 : 0) != 0);
    }

    boolean equals(Object added, Object oid) {
        if (added.equals(oid)) {
            return true;
        }
        if (added instanceof Id) {
            return ((Id)added).getIdObject().equals(oid);
        }
        return false;
    }

    public static class RemoteCommitProviderTestImpl
    extends AbstractRemoteCommitProvider {
        Collection added;
        Collection updated;
        Collection deleted;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteCommitProviderTestImpl() {
            Object object = currentProviderLock;
            synchronized (object) {
                currentProvider = this;
            }
        }

        public void broadcast(RemoteCommitEvent event) {
            this.added = event.getPersistedObjectIds();
            this.updated = event.getUpdatedObjectIds();
            this.deleted = event.getDeletedObjectIds();
        }

        public void close() {
        }
    }

    private static class RemoteCommitListenerTestImpl
    implements RemoteCommitListener {
        transient Collection added;
        transient Collection updated;
        transient Collection deleted;

        private RemoteCommitListenerTestImpl() {
        }

        public void afterCommit(RemoteCommitEvent event) {
            this.added = event.getPersistedObjectIds();
            this.updated = event.getUpdatedObjectIds();
            this.deleted = event.getDeletedObjectIds();
        }

        public void close() {
        }
    }
}

