/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.StoreCache;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest1;
import org.apache.openjpa.util.Id;

public class RemoteEventBase
extends AbstractTestCase {
    public Id roid;
    public StoreCache datacatch;

    public RemoteEventBase(String s) {
        super(s, "eventcactusapp");
    }

    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
        this.datacatch.evictAll();
    }

    public void tearDown() throws Exception {
        ((OpenJPAEntityManagerSPI)OpenJPAPersistence.cast((EntityManager)this.currentEntityManager())).getConfiguration().getRemoteCommitEventManager().close();
    }

    protected void doTest(Class providerClass, String classProps1, String classProps2) {
        String transmit = "TransmitPersistedObjectIds=true";
        classProps1 = classProps1 == null || classProps1.length() == 0 ? transmit : classProps1 + "," + transmit;
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.RemoteCommitProvider", Configurations.getPlugin((String)providerClass.getName(), (String)classProps1));
        propsMap.put("openjpa.FetchGroups", "differentiatingFetchGroup1");
        propsMap.put("openjpa.DataCache", "true");
        OpenJPAEntityManagerFactory factory1 = this.getEmf(propsMap);
        TriggerRemoteCommitListener listener1 = new TriggerRemoteCommitListener();
        ((OpenJPAEntityManagerFactorySPI)factory1).getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)listener1);
        classProps2 = classProps2 == null || classProps2.length() == 0 ? transmit : classProps2 + ", " + transmit;
        propsMap = new HashMap();
        propsMap.put("openjpa.RemoteCommitProvider", Configurations.getPlugin((String)providerClass.getName(), (String)classProps2));
        propsMap.put("openjpa.FetchGroups", "differentiatingFetchGroup2");
        propsMap.put("openjpa.DataCache", "true");
        OpenJPAEntityManagerFactory factory2 = this.getEmf(propsMap);
        RemoteCommitListenerTestImpl listener2 = new RemoteCommitListenerTestImpl();
        ((OpenJPAEntityManagerFactorySPI)factory2).getConfiguration().getRemoteCommitEventManager().addListener((RemoteCommitListener)listener2);
        OpenJPAEntityManager pm = factory1.createEntityManager();
        this.datacatch = pm.getEntityManagerFactory().getStoreCache();
        RuntimeTest1 t1 = new RuntimeTest1("foo", 5);
        this.startTx((EntityManager)pm);
        pm.persist((Object)t1);
        Object oid = pm.getObjectId((Object)t1);
        this.roid = Id.newInstance(RuntimeTest1.class, (Object)oid);
        this.endTx((EntityManager)pm);
        try {
            Thread.currentThread();
            Thread.sleep(250L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        RemoteEventBase.assertFalse((boolean)listener1.commitNotificationReceived);
        RemoteEventBase.assertNotNull((Object)listener2.added);
        RemoteEventBase.assertNotNull((Object)listener2.updated);
        RemoteEventBase.assertNotNull((Object)listener2.deleted);
        boolean pass = false;
        Iterator iter = listener2.added.iterator();
        while (iter.hasNext()) {
            Id roid = Id.newInstance(RuntimeTest1.class, (Object)oid);
            Id it = (Id)iter.next();
            if (!it.toString().equals(roid.toString())) continue;
            pass = true;
            break;
        }
        RemoteEventBase.assertTrue((String)("pass = " + pass), (boolean)pass);
        RemoteEventBase.assertTrue((listener2.updated.size() == 0 ? 1 : 0) != 0);
        RemoteEventBase.assertTrue((listener2.deleted.size() == 0 ? 1 : 0) != 0);
        this.startTx((EntityManager)pm);
        t1.setStringField("baz");
        this.endTx((EntityManager)pm);
        try {
            Thread.currentThread();
            Thread.sleep(250L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        RemoteEventBase.assertFalse((boolean)listener1.commitNotificationReceived);
        RemoteEventBase.assertNotNull((Object)listener2.added);
        RemoteEventBase.assertNotNull((Object)listener2.updated);
        RemoteEventBase.assertNotNull((Object)listener2.deleted);
        pass = false;
        for (Id it : listener2.updated) {
            if (!it.toString().equals(this.roid.toString())) continue;
            pass = true;
            break;
        }
        RemoteEventBase.assertTrue((boolean)pass);
        RemoteEventBase.assertTrue((listener2.added.size() == 0 ? 1 : 0) != 0);
        RemoteEventBase.assertTrue((listener2.deleted.size() == 0 ? 1 : 0) != 0);
        this.startTx((EntityManager)pm);
        pm.remove((Object)t1);
        this.endTx((EntityManager)pm);
        try {
            Thread.currentThread();
            Thread.sleep(250L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        RemoteEventBase.assertFalse((boolean)listener1.commitNotificationReceived);
        RemoteEventBase.assertNotNull((Object)listener2.added);
        RemoteEventBase.assertNotNull((Object)listener2.updated);
        RemoteEventBase.assertNotNull((Object)listener2.deleted);
        pass = false;
        for (Id it : listener2.deleted) {
            if (!it.toString().equals(this.roid.toString())) continue;
            pass = true;
            break;
        }
        RemoteEventBase.assertTrue((boolean)pass);
        RemoteEventBase.assertTrue((listener2.added.size() == 0 ? 1 : 0) != 0);
        RemoteEventBase.assertTrue((listener2.updated.size() == 0 ? 1 : 0) != 0);
    }

    protected static class TriggerRemoteCommitListener
    implements RemoteCommitListener {
        boolean commitNotificationReceived = false;

        protected TriggerRemoteCommitListener() {
        }

        public void afterCommit(RemoteCommitEvent event) {
            this.commitNotificationReceived = true;
        }

        public void close() {
        }
    }

    protected static class RemoteCommitListenerTestImpl
    implements RemoteCommitListener {
        transient Collection added;
        transient Collection updated;
        transient Collection deleted;

        protected RemoteCommitListenerTestImpl() {
        }

        public void afterCommit(RemoteCommitEvent event) {
            this.added = event.getPersistedObjectIds();
            this.updated = event.getUpdatedObjectIds();
            this.deleted = event.getDeletedObjectIds();
        }

        public void close() {
        }
    }
}

