/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.enhance.identity.Dependent1Xml;
import org.apache.openjpa.persistence.enhance.identity.DependentId1Xml;
import org.apache.openjpa.persistence.enhance.identity.Employee1Xml;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMapsIdXml
extends SingleEMFTestCase {
    public int numEmployees = 4;
    public int numDependentsPerEmployee = 2;
    public int numPersons = 4;
    public Map<Integer, Employee1Xml> emps1xml = new HashMap<Integer, Employee1Xml>();
    public Map<String, Dependent1Xml> deps1xml = new HashMap<String, Dependent1Xml>();
    public int eId1 = 1;
    public int dId1 = 1;

    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES);
    }

    protected String getPersistenceUnitName() {
        return "mapsId-pu";
    }

    public void testMapsId1Xml() {
        this.createObj1Xml();
        this.findObj1Xml();
        this.queryObj1Xml();
    }

    public void createObj1Xml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            this.createEmployee1Xml((EntityManager)em, this.eId1++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee1Xml createEmployee1Xml(EntityManager em, int id) {
        Employee1Xml e = new Employee1Xml();
        e.setEmpId(id);
        e.setName("emp_" + id);
        for (int i = 0; i < this.numDependentsPerEmployee; ++i) {
            Dependent1Xml d = this.createDependent1Xml(em, this.dId1++, e);
            e.addDependent(d);
            em.persist((Object)d);
        }
        em.persist((Object)e);
        this.emps1xml.put(id, e);
        return e;
    }

    public Dependent1Xml createDependent1Xml(EntityManager em, int id, Employee1Xml e) {
        Dependent1Xml d = new Dependent1Xml();
        DependentId1Xml did = new DependentId1Xml();
        did.setName("dep_" + id);
        d.setId(did);
        d.setEmp(e);
        this.deps1xml.put(did.getName(), d);
        return d;
    }

    public void findObj1Xml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee1Xml e = (Employee1Xml)em.find(Employee1Xml.class, (Object)1);
        List<Dependent1Xml> ds = e.getDependents();
        TestMapsIdXml.assertEquals((int)this.numDependentsPerEmployee, (int)ds.size());
        Employee1Xml e0 = this.emps1xml.get(1);
        TestMapsIdXml.assertEquals((Object)e0, (Object)e);
    }

    public void queryObj1Xml() {
        this.queryDependent1Xml();
    }

    public void queryDependent1Xml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String jpql = "select d from Dependent1Xml d where d.id.name = 'dep_1' AND d.emp.name = 'emp_1'";
        Query q = em.createQuery(jpql);
        List ds = q.getResultList();
        for (Dependent1Xml d : ds) {
            this.assertDependent1Xml(d);
        }
        tran.commit();
        em.close();
    }

    public void assertDependent1Xml(Dependent1Xml d) {
        DependentId1Xml id = d.getId();
        Dependent1Xml d0 = this.deps1xml.get(id.getName());
        if (d0.id.empPK == 0L) {
            d0.id.empPK = d0.emp.getEmpId();
        }
        TestMapsIdXml.assertEquals((Object)d0, (Object)d);
    }
}

