/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.openjpa.persistence.enhance.identity.Book1;
import org.apache.openjpa.persistence.enhance.identity.Line1;
import org.apache.openjpa.persistence.enhance.identity.LineId1;
import org.apache.openjpa.persistence.enhance.identity.PageId1;
import org.apache.openjpa.persistence.jdbc.VersionColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DI_PAGE1")
@VersionColumn
public class Page1
implements Serializable {
    @EmbeddedId
    @AttributeOverride(name="number", column=@Column(name="PAGE_NUM"))
    private PageId1 pid;
    @MapsId(value="book")
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="LIBRARY_NAME", referencedColumnName="LIBRARY_NAME"), @JoinColumn(name="BOOK_NAME", referencedColumnName="BOOK_NAME")})
    private Book1 book;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="page")
    private Set<Line1> lines = new HashSet<Line1>();

    public PageId1 getPid() {
        return this.pid;
    }

    public void setPid(PageId1 pid) {
        this.pid = pid;
    }

    public Book1 getBook() {
        return this.book;
    }

    public void setBook(Book1 book) {
        this.book = book;
    }

    public Set<Line1> getLines() {
        return this.lines;
    }

    public Line1 getLine(LineId1 lid) {
        for (Line1 l : this.lines) {
            if (!l.getLid().equals(lid)) continue;
            return l;
        }
        return null;
    }

    public void addLine(Line1 l) {
        l.setPage(this);
        this.lines.add(l);
    }
}

