/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.openjpa.persistence.enhance.identity.Book1;
import org.apache.openjpa.persistence.enhance.identity.BookId1;
import org.apache.openjpa.persistence.jdbc.VersionColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="DI_LIBRARY1")
@VersionColumn
public class Library1
implements Serializable {
    @Id
    @Column(name="LIBRARY_NAME", nullable=false)
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="library")
    private Set<Book1> books = new HashSet<Book1>();
    private String location;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Book1> getBooks() {
        return this.books;
    }

    public Book1 getBook(BookId1 bid) {
        for (Book1 b : this.books) {
            if (!b.getBid().equals(bid)) continue;
            return b;
        }
        return null;
    }

    public void addBook(Book1 book) {
        book.setLibrary(this);
        this.books.add(book);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Library1)) {
            return false;
        }
        Library1 other = (Library1)o;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

