/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.openjpa.persistence.enhance.identity.Book;
import org.apache.openjpa.persistence.jdbc.VersionColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@VersionColumn
public class Library
implements Serializable {
    @Id
    @Column(name="LIBRARY_NAME", nullable=false)
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="library")
    private Set<Book> books = new HashSet<Book>();
    private String location;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Book> getBooks() {
        return this.books;
    }

    public Book getBook(String name) {
        for (Book b : this.books) {
            if (!b.getName().equals(name)) continue;
            return b;
        }
        return null;
    }

    public void addBook(Book book) {
        book.setLibrary(this);
        this.books.add(book);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Library)) {
            return false;
        }
        Library other = (Library)o;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

