/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.openjpa.persistence.enhance.identity.BookId1;
import org.apache.openjpa.persistence.enhance.identity.Library1;
import org.apache.openjpa.persistence.enhance.identity.Page1;
import org.apache.openjpa.persistence.enhance.identity.PageId1;
import org.apache.openjpa.persistence.jdbc.VersionColumn;

@Entity
@Table(name="DI_BOOK1")
@VersionColumn
public class Book1
implements Serializable {
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="name", column=@Column(name="BOOK_NAME")), @AttributeOverride(name="library", column=@Column(name="LIBRARY_NAME"))})
    private BookId1 bid;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="book")
    private Set<Page1> pages = new HashSet<Page1>();
    @MapsId(value="library")
    @ManyToOne
    @JoinColumn(name="LIBRARY_NAME", referencedColumnName="LIBRARY_NAME")
    private Library1 library;
    private String author;

    public BookId1 getBid() {
        return this.bid;
    }

    public void setBid(BookId1 bid) {
        this.bid = bid;
    }

    public Library1 getLibrary() {
        return this.library;
    }

    public void setLibrary(Library1 library) {
        this.library = library;
    }

    public Page1 getPage(PageId1 pid) {
        for (Page1 p : this.pages) {
            if (!p.getPid().equals(pid)) continue;
            return p;
        }
        return null;
    }

    public void addPage(Page1 p) {
        p.setBook(this);
        this.pages.add(p);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Book1)) {
            return false;
        }
        Book1 other = (Book1)o;
        return this.getBid().equals(other.getBid());
    }

    public int hashCode() {
        return this.getBid().hashCode();
    }
}

