/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance.identity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.openjpa.persistence.enhance.identity.BookId;
import org.apache.openjpa.persistence.enhance.identity.Library;
import org.apache.openjpa.persistence.enhance.identity.Page;
import org.apache.openjpa.persistence.jdbc.VersionColumn;

@Entity
@IdClass(value=BookId.class)
@VersionColumn
public class Book
implements Serializable {
    @Id
    @Column(name="BOOK_NAME", nullable=false)
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="book")
    private Set<Page> pages = new HashSet<Page>();
    @Id
    @Column(nullable=false)
    @ManyToOne(cascade={CascadeType.MERGE})
    private Library library;
    private String author;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Library getLibrary() {
        return this.library;
    }

    public void setLibrary(Library library) {
        this.library = library;
    }

    public Page getPage(int n) {
        for (Page p : this.pages) {
            if (p.getNumber() != n) continue;
            return p;
        }
        return null;
    }

    public void addPage(Page p) {
        p.setBook(this);
        this.pages.add(p);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Book)) {
            return false;
        }
        Book other = (Book)o;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

