/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance;

import java.util.Date;
import org.apache.openjpa.enhance.DynamicStorage;
import org.apache.openjpa.enhance.DynamicStorageGenerator;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;

public class TestDynamicStorageGenerator
extends AbstractTestCase {
    public TestDynamicStorageGenerator(String s) {
        super(s, "enhancecactusapp");
    }

    public void testStorage() throws Exception {
        DynamicStorageGenerator gen = new DynamicStorageGenerator();
        int[] types = new int[]{0, 1, 2, 5, 7, 6, 4, 3, 9, 8};
        DynamicStorage storage = gen.generateStorage(types, (Object)"org.apache.openjpa.enhance.Test");
        storage = storage.newInstance();
        storage.setBoolean(0, true);
        storage.setByte(1, (byte)1);
        storage.setChar(2, 'f');
        storage.setInt(3, 3);
        storage.setShort(4, (short)4);
        storage.setLong(5, 5L);
        storage.setFloat(6, 6.6f);
        storage.setDouble(7, 7.7);
        storage.setObject(8, (Object)"field8");
        Date date = new Date();
        storage.setObject(9, (Object)date);
        TestDynamicStorageGenerator.assertTrue((boolean)storage.getBoolean(0));
        TestDynamicStorageGenerator.assertEquals((int)1, (int)storage.getByte(1));
        TestDynamicStorageGenerator.assertEquals((char)'f', (char)storage.getChar(2));
        TestDynamicStorageGenerator.assertEquals((int)3, (int)storage.getInt(3));
        TestDynamicStorageGenerator.assertEquals((int)4, (int)storage.getShort(4));
        TestDynamicStorageGenerator.assertEquals((long)5L, (long)storage.getLong(5));
        TestDynamicStorageGenerator.assertTrue((6.59 < (double)storage.getFloat(6) && 6.61 > (double)storage.getFloat(6) ? 1 : 0) != 0);
        TestDynamicStorageGenerator.assertTrue((7.69 < storage.getDouble(7) && 7.71 > storage.getDouble(7) ? 1 : 0) != 0);
        TestDynamicStorageGenerator.assertEquals((Object)"field8", (Object)storage.getObject(8));
        TestDynamicStorageGenerator.assertEquals((Object)date, (Object)storage.getObject(9));
    }
}

