/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed.attrOverrides;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.embed.attrOverrides.AddressXml;
import org.apache.openjpa.persistence.embed.attrOverrides.AnnoOverEmbed;
import org.apache.openjpa.persistence.embed.attrOverrides.BasicEmbedXML;
import org.apache.openjpa.persistence.embed.attrOverrides.BasicEntityXML;
import org.apache.openjpa.persistence.embed.attrOverrides.CustomerXml;
import org.apache.openjpa.persistence.embed.attrOverrides.XMLOverEntity;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestAttrOverridesXml
extends SQLListenerTestCase {
    public int numPersons = 4;
    public List<String> namedQueries = new ArrayList<String>();
    public int eId = 1;

    public void setUp() {
        this.setUp(AnnoOverEmbed.class, DROP_TABLES);
    }

    protected String getPersistenceUnitName() {
        return "embed-pu";
    }

    @AllowFailure(message="Multi-level embeddingJPA 2.0 Access Style XML Metadata Attribute Override  is not yet supported")
    public void testAttrOverride1() {
        this.sql.clear();
        this.createObj1();
        this.findObj1();
        this.queryObj1();
        this.assertAttrOverrides("CustomerXml1");
    }

    public void testBasicEmbedAttrOverride() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        BasicEntityXML be = new BasicEntityXML();
        be.setId(new Random().nextInt());
        BasicEmbedXML bem = new BasicEmbedXML();
        bem.setNotIntegerValue(new Random().nextInt());
        ArrayList<BasicEmbedXML> al = new ArrayList<BasicEmbedXML>();
        al.add(bem);
        be.setListIntAttrOverEmbed(al);
        em.getTransaction().begin();
        em.persist((Object)be);
        em.getTransaction().commit();
        TestAttrOverridesXml.assertTrue((boolean)this.verifyColumnOverride(em, "listIntAttrOverEmbedColTable", "intValueAttributeOverride"));
        em.close();
    }

    public void testXMLEntityWithAnnotatedOverrideEmbed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XMLOverEntity xoe = new XMLOverEntity();
        xoe.setId(new Random().nextInt());
        AnnoOverEmbed aoe = new AnnoOverEmbed();
        aoe.setIntEmbed(1);
        aoe.setStrEmbed("StrVal");
        xoe.setEmbed(aoe);
        em.getTransaction().begin();
        em.persist((Object)xoe);
        em.getTransaction().commit();
        TestAttrOverridesXml.assertTrue((boolean)this.verifyColumnOverride(em, "XMLOverEntity", "intOverEmbed"));
        TestAttrOverridesXml.assertFalse((boolean)this.verifyColumnOverride(em, "XMLOverEntity", "intEmbed"));
        TestAttrOverridesXml.assertTrue((boolean)this.verifyColumnOverride(em, "XMLOverEntity", "strOverEmbed"));
        TestAttrOverridesXml.assertFalse((boolean)this.verifyColumnOverride(em, "XMLOverEntity", "strEmbed"));
        em.close();
    }

    public void createObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numPersons; ++i) {
            this.createCustomer1((EntityManager)em, this.eId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public CustomerXml createCustomer1(EntityManager em, int id) {
        CustomerXml p = new CustomerXml();
        p.setId(id);
        AddressXml addr = new AddressXml();
        addr.setCity("city_" + id);
        addr.setState("state_" + id);
        addr.setStreet("street_" + id);
        p.setAddress(addr);
        p.setName("name_" + id);
        em.persist((Object)p);
        return p;
    }

    public void findObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CustomerXml p = (CustomerXml)em.find(CustomerXml.class, (Object)1);
        Assert.assertEquals((Object)p.getId(), (Object)new Integer(1));
        Assert.assertEquals((String)p.getAddress().getCity(), (String)"city_1");
        Assert.assertEquals((String)p.getAddress().getStreet(), (String)"street_1");
        Assert.assertEquals((String)p.getAddress().getState(), (String)"state_1");
        Assert.assertEquals((String)p.getName(), (String)"name_1");
    }

    public void queryObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String jpql = "select p from CustomerXml1 p";
        Query q = em.createQuery(jpql);
        List ps = q.getResultList();
        Assert.assertEquals((int)ps.size(), (int)this.numPersons);
        tran.commit();
        em.close();
    }

    public void assertAttrOverrides(String tableName) {
        boolean found = false;
        for (String sqlStr : this.sql) {
            if (sqlStr.indexOf("CREATE TABLE " + tableName) == -1 || !tableName.equals("CustomerXml1")) continue;
            found = true;
            if (sqlStr.indexOf("ADDR_STATE") != -1 && sqlStr.indexOf("ADDR_ZIP") != -1) continue;
            TestAttrOverridesXml.fail();
        }
        if (!found) {
            TestAttrOverridesXml.fail();
        }
    }

    private boolean verifyColumnOverride(OpenJPAEntityManagerSPI em, String tableName, String columnName) {
        JDBCConfiguration conf = (JDBCConfiguration)em.getEntityManagerFactory().getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        Connection conn = (Connection)em.getConnection();
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            Column[] cols = dict.getColumns(dbmd, null, null, tableName, columnName, conn);
            if (cols != null && cols.length == 1) {
                Column col = cols[0];
                String colName = col.getName();
                if (col.getTableName().equalsIgnoreCase(tableName) && colName.equalsIgnoreCase(columnName)) {
                    return true;
                }
            }
        }
        catch (Throwable e) {
            TestAttrOverridesXml.fail((String)"Unable to get column information.");
        }
        return false;
    }
}

