/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.RollbackException;
import org.apache.openjpa.persistence.embed.Address;
import org.apache.openjpa.persistence.embed.BaseEntity;
import org.apache.openjpa.persistence.embed.Embed;
import org.apache.openjpa.persistence.embed.Embed_Embed;
import org.apache.openjpa.persistence.embed.EntityA_Embed_Embed;
import org.apache.openjpa.persistence.embed.Geocode;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestUpdateEmbeddedQueryResult
extends SingleEMFTestCase {
    public int ID = 1;

    public void setUp() {
        this.setUp(Embed.class, Embed_Embed.class, EntityA_Embed_Embed.class, BaseEntity.class, Address.class, Geocode.class, DROP_TABLES);
    }

    public void testUpdateEmbedded() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Address a = new Address();
        a.setStreetAddress("555 Bailey Ave");
        a.setCity("San Jose");
        a.setState("CA");
        a.setZip(12955);
        Geocode g = new Geocode();
        g.setLatitude(1.0f);
        g.setLongtitude(2.0f);
        a.setGeocode(g);
        em.getTransaction().begin();
        em.persist((Object)a);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        String query = "select address from Address address where address.streetAddress = '555 Bailey Ave'";
        List list = em.createQuery(query).getResultList();
        Address a1 = (Address)list.get(0);
        TestUpdateEmbeddedQueryResult.assertEquals((Object)Float.valueOf(a1.getGeocode().getLatitude()), (Object)Float.valueOf(1.0f));
        Long id = a1.getId();
        g = new Geocode();
        g.setLatitude(3.0f);
        g.setLongtitude(4.0f);
        a1.setGeocode(g);
        em.getTransaction().commit();
        Address a2 = (Address)em.find(Address.class, (Object)id);
        TestUpdateEmbeddedQueryResult.assertEquals((Object)Float.valueOf(a2.getGeocode().getLatitude()), (Object)Float.valueOf(3.0f));
        em.getTransaction().begin();
        g.setLatitude(5.0f);
        a2.setGeocode(g);
        em.getTransaction().commit();
        em.clear();
        Address a3 = (Address)em.find(Address.class, (Object)id);
        TestUpdateEmbeddedQueryResult.assertEquals((Object)Float.valueOf(a3.getGeocode().getLatitude()), (Object)Float.valueOf(5.0f));
        em.clear();
        query = "select a.geocode from Address a where a.id = ?1";
        List rs = em.createQuery(query).setParameter(1, (Object)id).getResultList();
        Geocode g2 = (Geocode)rs.get(0);
        em.getTransaction().begin();
        try {
            g2.setLatitude(7.0f);
        }
        catch (ArgumentException e) {
            // empty catch block
        }
        try {
            em.getTransaction().commit();
        }
        catch (RollbackException e) {
            // empty catch block
        }
        em.close();
    }

    public void testEntityA_Embed_Embed_update() {
        this.createEntityA_Embed_Embed();
        this.updateEmbedded_EntityA_Embed_Embed();
    }

    public void createEntityA_Embed_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Embed_Embed((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Embed_Embed(EntityManager em, int id) {
        EntityA_Embed_Embed a = new EntityA_Embed_Embed();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        Embed_Embed embed = this.createEmbed_Embed(em, id, 0);
        a.setEmbed(embed);
        em.persist((Object)a);
    }

    public Embed_Embed createEmbed_Embed(EntityManager em, int id, int idx) {
        Embed_Embed embed = new Embed_Embed();
        embed.setIntVal1(id * 100 + idx * 10 + 1);
        embed.setIntVal2(id * 100 + idx * 10 + 2);
        embed.setIntVal3(id * 100 + idx * 10 + 3);
        Embed embed1 = this.createEmbed(id, idx);
        embed.setEmbed(embed1);
        return embed;
    }

    public Embed createEmbed(int id, int idx) {
        Embed embed = new Embed();
        embed.setIntVal1(id * 100 + idx * 10 + 4);
        embed.setIntVal2(id * 100 + idx * 10 + 5);
        embed.setIntVal3(id * 100 + idx * 10 + 6);
        return embed;
    }

    public void testBulkUpdateEmbeddedField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String update = "UPDATE EntityA_Embed_Embed a set a.embed.embed.intVal1 = ?1, a.embed.embed.intVal2 = ?2 where a.id = 10";
        em.getTransaction().begin();
        int count = em.createQuery(update).setParameter(1, (Object)100).setParameter(2, (Object)200).executeUpdate();
        em.getTransaction().commit();
        TestUpdateEmbeddedQueryResult.assertEquals((int)count, (int)0);
        update = "UPDATE EntityA_Embed_Embed a set a.embed.embed = ?1";
        Embed embed1 = this.createEmbed(this.ID, 10);
        try {
            int updateCount = em.createQuery(update).setParameter(1, (Object)embed1).executeUpdate();
        }
        catch (ArgumentException e) {
            // empty catch block
        }
        em.close();
    }

    public void updateEmbedded_EntityA_Embed_Embed() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        String[] query = new String[]{"select a.embed from EntityA_Embed_Embed a", "select a.embed.embed from EntityA_Embed_Embed a", "select a.embed as e from EntityA_Embed_Embed a ORDER BY e"};
        List rs = null;
        Embed_Embed embedembed = null;
        Embed embed = null;
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        for (int i = 0; i < query.length; ++i) {
            rs = em.createQuery(query[i]).getResultList();
            TestUpdateEmbeddedQueryResult.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            try {
                switch (i) {
                    case 0: 
                    case 2: {
                        embedembed = (Embed_Embed)rs.get(0);
                        embedembed.getEmbed().setIntVal1(1111);
                        embedembed.setEmbed(embed);
                        break;
                    }
                    case 1: {
                        embed = (Embed)rs.get(0);
                        embed.setIntVal1(1111);
                    }
                }
                continue;
            }
            catch (ArgumentException e) {
                // empty catch block
            }
        }
        try {
            tran.commit();
        }
        catch (RollbackException e) {
            // empty catch block
        }
        em.close();
    }
}

