/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.embed.CompanyXml;
import org.apache.openjpa.persistence.embed.CustomerXml;
import org.apache.openjpa.persistence.embed.DepartmentXml;
import org.apache.openjpa.persistence.embed.DivisionXml;
import org.apache.openjpa.persistence.embed.EmbedXml;
import org.apache.openjpa.persistence.embed.Embed_EmbedXml;
import org.apache.openjpa.persistence.embed.EmployeeXml;
import org.apache.openjpa.persistence.embed.EntityA_Coll_Embed_EmbedXml;
import org.apache.openjpa.persistence.embed.EntityA_Coll_StringXml;
import org.apache.openjpa.persistence.embed.ItemXml;
import org.apache.openjpa.persistence.embed.OrderXml;
import org.apache.openjpa.persistence.embed.VicePresidentXml;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

@AllowFailure(message="Multi-level embeddingJPA 2.0 Access Style XML Metadata Attribute Override  is not yet supported")
public class TestEmbeddableXml
extends SingleEMFTestCase {
    public int numEmbeddables = 1;
    public int numBasicTypes = 10;
    public int ID = 1;
    public int deptId = 1;
    public int empId = 1;
    public int compId = 1;
    public int divId = 1;
    public int vpId = 1;
    public int newDivId = 100;
    public int newVpId = 100;
    public int numItems = 2;
    public int itemId = 1;
    public int cId = 1;
    public int oId = 1;
    public int numImagesPerItem = 3;
    public int numDepartments = 2;
    public int numEmployeesPerDept = 2;
    public int numCompany = 2;
    public int numDivisionsPerCo = 2;
    public int numCustomers = 1;
    public int numOrdersPerCustomer = 2;

    public void setUp() {
        this.setUp(CLEAR_TABLES);
    }

    protected String getPersistenceUnitName() {
        return "embed-pu";
    }

    public void testEntityA_Coll_StringXml() {
        this.createEntityA_Coll_StringXml();
        this.queryEntityA_Coll_StringXml();
        this.findEntityA_Coll_StringXml();
    }

    public void testEntityA_Coll_Embed_Embed() {
        this.createEntityA_Coll_Embed_EmbedXml();
        this.queryEntityA_Coll_Embed_EmbedXml();
        this.findEntityA_Coll_Embed_EmbedXml();
    }

    public void createEntityA_Coll_StringXml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Coll_StringXml((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Coll_StringXml(EntityManager em, int id) {
        EntityA_Coll_StringXml a = new EntityA_Coll_StringXml();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        for (int i = 0; i < this.numBasicTypes; ++i) {
            a.addNickName("nickName_" + id + i);
        }
        em.persist((Object)a);
    }

    public void createEntityA_Coll_Embed_EmbedXml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        this.createEntityA_Coll_Embed_EmbedXml((EntityManager)em, this.ID);
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createEntityA_Coll_Embed_EmbedXml(EntityManager em, int id) {
        EntityA_Coll_Embed_EmbedXml a = new EntityA_Coll_Embed_EmbedXml();
        a.setId(id);
        a.setName("a" + id);
        a.setAge(id);
        for (int i = 0; i < this.numEmbeddables; ++i) {
            Embed_EmbedXml embed = this.createEmbed_EmbedXml(em, id, i);
            a.addEmbed(embed);
        }
        em.persist((Object)a);
    }

    public Embed_EmbedXml createEmbed_EmbedXml(EntityManager em, int id, int idx) {
        Embed_EmbedXml embed = new Embed_EmbedXml();
        embed.setIntVal1(id * 100 + idx * 10 + 1);
        embed.setIntVal2(id * 100 + idx * 10 + 2);
        embed.setIntVal3(id * 100 + idx * 10 + 3);
        EmbedXml embed1 = this.createEmbedXml(id, idx);
        embed.setEmbed(embed1);
        return embed;
    }

    public EmbedXml createEmbedXml(int id, int idx) {
        EmbedXml embed = new EmbedXml();
        embed.setIntVal1(id * 100 + idx * 10 + 4);
        embed.setIntVal2(id * 100 + idx * 10 + 5);
        embed.setIntVal3(id * 100 + idx * 10 + 6);
        return embed;
    }

    public void findEntityA_Coll_StringXml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Coll_StringXml a = (EntityA_Coll_StringXml)em.find(EntityA_Coll_StringXml.class, (Object)this.ID);
        this.checkEntityA_Coll_StringXml(a);
        Query q = em.createNativeQuery("select count(*) from EntityA_Coll_StringXml_nickNames");
        Object obj = q.getSingleResult();
        TestEmbeddableXml.assertEquals((Object)this.numBasicTypes, (Object)obj);
        em.close();
    }

    public void findEntityA_Coll_Embed_EmbedXml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityA_Coll_Embed_EmbedXml a = (EntityA_Coll_Embed_EmbedXml)em.find(EntityA_Coll_Embed_EmbedXml.class, (Object)this.ID);
        this.checkEntityA_Coll_Embed_EmbedXml(a);
        em.close();
    }

    public void checkEntityA_Coll_StringXml(EntityA_Coll_StringXml a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddableXml.assertEquals((int)1, (int)id);
        TestEmbeddableXml.assertEquals((String)("a" + id), (String)name);
        TestEmbeddableXml.assertEquals((int)1, (int)age);
        Set<String> nickNames = a.getNickNames();
        for (String nickName : nickNames) {
            TestEmbeddableXml.assertEquals((String)("nickName_" + id + "0"), (String)nickName);
        }
    }

    public void checkEntityA_Coll_Embed_EmbedXml(EntityA_Coll_Embed_EmbedXml a) {
        int id = a.getId();
        String name = a.getName();
        int age = a.getAge();
        TestEmbeddableXml.assertEquals((int)1, (int)id);
        TestEmbeddableXml.assertEquals((String)("a" + id), (String)name);
        TestEmbeddableXml.assertEquals((int)1, (int)age);
        List<Embed_EmbedXml> embeds = a.getEmbeds();
        for (Embed_EmbedXml embed : embeds) {
            this.checkEmbed_EmbedXml(embed);
        }
    }

    public void checkEmbed_EmbedXml(Embed_EmbedXml embed) {
        int intVal1 = embed.getIntVal1();
        int intVal2 = embed.getIntVal2();
        int intVal3 = embed.getIntVal3();
        TestEmbeddableXml.assertEquals((int)101, (int)intVal1);
        TestEmbeddableXml.assertEquals((int)102, (int)intVal2);
        TestEmbeddableXml.assertEquals((int)103, (int)intVal3);
        EmbedXml embed1 = embed.getEmbed();
        this.checkEmbedXml(embed1);
    }

    public void checkEmbedXml(EmbedXml embed) {
        int intVal1 = embed.getIntVal1();
        int intVal2 = embed.getIntVal2();
        int intVal3 = embed.getIntVal3();
        TestEmbeddableXml.assertEquals((int)104, (int)intVal1);
        TestEmbeddableXml.assertEquals((int)105, (int)intVal2);
        TestEmbeddableXml.assertEquals((int)106, (int)intVal3);
    }

    public void queryEntityA_Coll_StringXml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Coll_StringXml a");
        List as = q.getResultList();
        for (EntityA_Coll_StringXml a : as) {
            this.checkEntityA_Coll_StringXml(a);
        }
        tran.commit();
        em.close();
    }

    public void queryEntityA_Coll_Embed_EmbedXml() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select a from EntityA_Coll_Embed_EmbedXml a");
        List as = q.getResultList();
        for (EntityA_Coll_Embed_EmbedXml a : as) {
            this.checkEntityA_Coll_Embed_EmbedXml(a);
        }
        tran.commit();
        em.close();
    }

    public void testMapKeyAnnotations() {
        this.createObj();
        this.queryObj();
        this.findObj();
    }

    public void createObj() {
        this.createDepartments();
        this.createCompanies();
        this.createItems();
    }

    public void findObj() {
        this.findDepartment();
        this.findCompany();
        this.findItem();
    }

    public void createDepartments() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numDepartments; ++i) {
            this.createDepartment((EntityManager)em, this.deptId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createCompanies() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numCompany; ++i) {
            this.createCompany((EntityManager)em, this.compId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createItems() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numItems; ++i) {
            this.createItem((EntityManager)em, this.itemId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public void createItem(EntityManager em, int id) {
        ItemXml item = new ItemXml();
        item.setId(id);
        for (int i = 0; i < this.numImagesPerItem; ++i) {
            item.addImage("image" + id + i, "file" + id + i);
        }
        em.persist((Object)item);
    }

    public void createDepartment(EntityManager em, int id) {
        DepartmentXml d = new DepartmentXml();
        d.setDeptId(id);
        HashMap<Integer, EmployeeXml> emps = new HashMap<Integer, EmployeeXml>();
        for (int i = 0; i < this.numEmployeesPerDept; ++i) {
            EmployeeXml e = this.createEmployee(em, this.empId++);
            d.addEmployee(e);
            emps.put(e.getEmpId(), e);
            e.setDepartment(d);
            em.persist((Object)e);
        }
        em.persist((Object)d);
    }

    public EmployeeXml createEmployee(EntityManager em, int id) {
        EmployeeXml e = new EmployeeXml();
        e.setEmpId(id);
        return e;
    }

    public void createCompany(EntityManager em, int id) {
        CompanyXml c = new CompanyXml();
        c.setId(id);
        for (int i = 0; i < this.numDivisionsPerCo; ++i) {
            DivisionXml d = this.createDivision(em, this.divId++);
            VicePresidentXml vp = this.createVicePresident(em, this.vpId++);
            c.addToOrganization(d, vp);
            em.persist((Object)d);
            em.persist((Object)vp);
        }
        em.persist((Object)c);
    }

    public DivisionXml createDivision(EntityManager em, int id) {
        DivisionXml d = new DivisionXml();
        d.setId(id);
        d.setName("d" + id);
        return d;
    }

    public VicePresidentXml createVicePresident(EntityManager em, int id) {
        VicePresidentXml vp = new VicePresidentXml();
        vp.setId(id);
        vp.setName("vp" + id);
        return vp;
    }

    public void findCompany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CompanyXml c = (CompanyXml)em.find(CompanyXml.class, (Object)1);
        this.assertCompany(c);
        DivisionXml d = (DivisionXml)em.find(DivisionXml.class, (Object)1);
        this.assertDivision(d);
        VicePresidentXml vp = (VicePresidentXml)em.find(VicePresidentXml.class, (Object)1);
        this.assertVicePresident(vp);
        this.updateCompany((EntityManager)em, c);
        em.close();
        em = this.emf.createEntityManager();
        c = (CompanyXml)em.find(CompanyXml.class, (Object)1);
        this.assertCompany(c);
        this.deleteCompany((EntityManager)em, c);
        em.close();
    }

    public void findDepartment() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DepartmentXml d = (DepartmentXml)em.find(DepartmentXml.class, (Object)1);
        this.assertDepartment(d);
        EmployeeXml e = (EmployeeXml)em.find(EmployeeXml.class, (Object)1);
        this.assertEmployee(e);
        this.updateDepartment((EntityManager)em, d);
        this.deleteDepartment((EntityManager)em, d);
        em.close();
    }

    public void findItem() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ItemXml item = (ItemXml)em.find(ItemXml.class, (Object)1);
        this.assertItem(item);
        this.updateItem((EntityManager)em, item);
        this.deleteItem((EntityManager)em, item);
        em.close();
    }

    public void updateItem(EntityManager em, ItemXml item) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        item.removeImage("image" + item.getId() + "0");
        em.persist((Object)item);
        em.flush();
        tran.commit();
        String key = "image" + item.getId() + "new";
        tran.begin();
        item.addImage(key, "file" + item.getId() + "new");
        em.persist((Object)item);
        em.flush();
        tran.commit();
        tran.begin();
        String fileName = item.getImage(key);
        fileName = fileName + "newAgain";
        item.addImage(key, fileName);
        em.persist((Object)item);
        em.flush();
        tran.commit();
    }

    public void deleteItem(EntityManager em, ItemXml item) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.remove((Object)item);
        tran.commit();
    }

    public void updateCompany(EntityManager em, CompanyXml c) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Map orgs = c.getOrganization();
        Set keys = orgs.keySet();
        Iterator i$ = keys.iterator();
        if (i$.hasNext()) {
            Object key = i$.next();
            DivisionXml d = (DivisionXml)key;
            c.removeFromOrganization(d);
        }
        em.persist((Object)c);
        em.flush();
        tran.commit();
        tran.begin();
        DivisionXml d = this.createDivision(em, this.newDivId++);
        VicePresidentXml vp = this.createVicePresident(em, this.newVpId++);
        c.addToOrganization(d, vp);
        em.persist((Object)d);
        em.persist((Object)vp);
        em.persist((Object)c);
        em.flush();
        tran.commit();
        tran.begin();
        orgs = c.getOrganization();
        vp = c.getOrganization(d);
        vp.setName("newNameAgain");
        em.persist((Object)c);
        em.persist((Object)vp);
        em.flush();
        tran.commit();
    }

    public void deleteCompany(EntityManager em, CompanyXml c) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.remove((Object)c);
        tran.commit();
    }

    public void updateDepartment(EntityManager em, DepartmentXml d) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        EmployeeXml e = this.createEmployee(em, this.numDepartments * this.numEmployeesPerDept + 1);
        d.addEmployee(e);
        e.setDepartment(d);
        em.persist((Object)d);
        em.persist((Object)e);
        em.flush();
        tran.commit();
        tran.begin();
        d.removeEmployee(e.getEmpId());
        e.setDepartment(null);
        em.persist((Object)d);
        em.persist((Object)e);
        em.flush();
        tran.commit();
    }

    public void deleteDepartment(EntityManager em, DepartmentXml d) {
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.remove((Object)d);
        tran.commit();
    }

    public void queryObj() {
        this.queryDepartment();
        this.queryEmployee();
        this.queryCompany();
        this.queryDivision();
        this.queryVicePresident();
        this.queryItem();
    }

    public void queryDepartment() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from DepartmentXml d");
        List ds = q.getResultList();
        for (DepartmentXml d : ds) {
            this.assertDepartment(d);
        }
        tran.commit();
        em.close();
    }

    public void queryEmployee() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from EmployeeXml e");
        List es = q.getResultList();
        for (EmployeeXml e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void queryCompany() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select c from CompanyXml c");
        List cs = q.getResultList();
        for (CompanyXml c : cs) {
            this.assertCompany(c);
        }
        tran.commit();
        em.close();
    }

    public void queryDivision() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select d from DivisionXml d");
        List ds = q.getResultList();
        for (DivisionXml d : ds) {
            this.assertDivision(d);
        }
        tran.commit();
        em.close();
    }

    public void queryVicePresident() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select vp from VicePresidentXml vp");
        List vps = q.getResultList();
        for (VicePresidentXml vp : vps) {
            this.assertVicePresident(vp);
        }
        tran.commit();
        em.close();
    }

    public void queryItem() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select i from ItemXml i");
        List is = q.getResultList();
        for (ItemXml item : is) {
            this.assertItem(item);
        }
        tran.commit();
        em.close();
    }

    public void assertDepartment(DepartmentXml d) {
        int id = d.getDeptId();
        Map<Integer, EmployeeXml> es = d.getEmpMap();
        TestEmbeddableXml.assertEquals((int)2, (int)es.size());
        Set<Integer> keys = es.keySet();
        Iterator<Integer> i$ = keys.iterator();
        while (i$.hasNext()) {
            Integer obj;
            Integer empId = obj = i$.next();
            EmployeeXml e = es.get(empId);
            TestEmbeddableXml.assertEquals((int)empId, (int)e.getEmpId());
        }
    }

    public void assertItem(ItemXml item) {
        int id = item.getId();
        Map images = item.getImages();
        TestEmbeddableXml.assertEquals((int)this.numImagesPerItem, (int)images.size());
    }

    public void assertEmployee(EmployeeXml e) {
        int id = e.getEmpId();
        DepartmentXml d = e.getDepartment();
        this.assertDepartment(d);
    }

    public void assertCompany(CompanyXml c) {
        int id = c.getId();
        Map organization = c.getOrganization();
        TestEmbeddableXml.assertEquals((int)2, (int)organization.size());
    }

    public void assertDivision(DivisionXml d) {
        int id = d.getId();
        String name = d.getName();
    }

    public void assertVicePresident(VicePresidentXml vp) {
        int id = vp.getId();
        String name = vp.getName();
    }

    public void createOrphanRemoval() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numCustomers; ++i) {
            this.createCustomer((EntityManager)em, this.cId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public CustomerXml createCustomer(EntityManager em, int id) {
        CustomerXml c = new CustomerXml();
        c.setId(id);
        c.setName("name" + id);
        for (int i = 0; i < this.numOrdersPerCustomer; ++i) {
            OrderXml order = this.createOrder(em, this.oId++);
            c.addOrder(order);
            order.setCust(c);
            em.persist((Object)order);
        }
        em.persist((Object)c);
        return c;
    }

    public OrderXml createOrder(EntityManager em, int id) {
        OrderXml o = new OrderXml();
        o.setId(id);
        em.persist((Object)o);
        return o;
    }

    public void testOrphanRemovalTarget() {
        this.createOrphanRemoval();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        int count = this.count(OrderXml.class);
        TestEmbeddableXml.assertEquals((int)(this.numOrdersPerCustomer * this.numCustomers), (int)count);
        CustomerXml c = (CustomerXml)em.find(CustomerXml.class, (Object)1);
        Set<OrderXml> orders = c.getOrders();
        TestEmbeddableXml.assertEquals((int)this.numOrdersPerCustomer, (int)orders.size());
        Iterator<OrderXml> i$ = orders.iterator();
        if (i$.hasNext()) {
            OrderXml order = i$.next();
            orders.remove(order);
        }
        em.getTransaction().begin();
        em.persist((Object)c);
        em.flush();
        em.getTransaction().commit();
        em.clear();
        c = (CustomerXml)em.find(CustomerXml.class, (Object)1);
        orders = c.getOrders();
        TestEmbeddableXml.assertEquals((int)(this.numOrdersPerCustomer - 1), (int)orders.size());
        count = this.count(OrderXml.class);
        TestEmbeddableXml.assertEquals((int)(this.numOrdersPerCustomer * this.numCustomers - 1), (int)count);
        em.close();
    }

    public void testOrphanRemovalTargetSetNull() {
        this.createOrphanRemoval();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CustomerXml c = (CustomerXml)em.find(CustomerXml.class, (Object)1);
        c.setOrders(null);
        em.getTransaction().begin();
        em.persist((Object)c);
        em.flush();
        em.getTransaction().commit();
        em.clear();
        int count = this.count(OrderXml.class);
        TestEmbeddableXml.assertEquals((int)(this.numOrdersPerCustomer * (this.numCustomers - 1)), (int)count);
        c = (CustomerXml)em.find(CustomerXml.class, (Object)1);
        Set<OrderXml> orders = c.getOrders();
        if (orders != null) {
            TestEmbeddableXml.assertEquals((int)0, (int)orders.size());
        }
        em.close();
    }

    public void testOrphanRemovalSource() {
        this.createOrphanRemoval();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CustomerXml c = (CustomerXml)em.find(CustomerXml.class, (Object)1);
        em.getTransaction().begin();
        em.remove((Object)c);
        em.flush();
        em.getTransaction().commit();
        em.clear();
        int count = this.count(OrderXml.class);
        TestEmbeddableXml.assertEquals((int)(this.numOrdersPerCustomer * (this.numCustomers - 1)), (int)count);
        em.close();
    }
}

