/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.discriminator.fetch;

import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.discriminator.fetch.Employee;
import org.apache.openjpa.persistence.discriminator.fetch.Manager;
import org.apache.openjpa.persistence.discriminator.fetch.Person;
import org.apache.openjpa.persistence.test.PersistenceTestCase;

public class TestLazyFetch
extends PersistenceTestCase {
    private static int N_EMPS = 3;

    public EntityManagerFactory newEmf() {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(Person.class, Employee.class, Manager.class);
        TestLazyFetch.assertNotNull((String)"Unable to create EntityManagerFactory", (Object)emf);
        return emf;
    }

    public void setUp() {
        EntityManagerFactory emf = this.newEmf();
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.createQuery("Delete from D_F_Manager").executeUpdate();
        em.createQuery("Delete from D_F_Employee").executeUpdate();
        tran.commit();
        tran.begin();
        Manager m = new Manager();
        m.setId(10);
        m.setEmployees(new HashSet<Employee>());
        em.persist((Object)m);
        for (int i = 0; i < N_EMPS; ++i) {
            Employee e = new Employee();
            e.setId(i + 1);
            e.setManager(m);
            m.getEmployees().add(e);
            em.persist((Object)e);
        }
        tran.commit();
        em.close();
        emf.close();
    }

    public void testFetchOneSideFirst() {
        EntityManagerFactory emf = this.newEmf();
        EntityManager em = emf.createEntityManager();
        List managers = em.createQuery("Select m from D_F_Manager m").getResultList();
        TestLazyFetch.assertEquals((int)1, (int)managers.size());
        Manager m = (Manager)managers.get(0);
        List emps = em.createQuery("Select e from D_F_Employee e").getResultList();
        TestLazyFetch.assertEquals((int)N_EMPS, (int)emps.size());
        for (Employee e : emps) {
            TestLazyFetch.assertNotNull((Object)e.getManager());
            TestLazyFetch.assertTrue((boolean)m.getEmployees().contains(e));
            TestLazyFetch.assertEquals((Object)m, (Object)e.getManager());
        }
        em.close();
        emf.close();
    }

    public void testFetchManySideFirst() {
        EntityManagerFactory emf = this.newEmf();
        EntityManager em = emf.createEntityManager();
        List emps = em.createQuery("Select e from D_F_Employee e").getResultList();
        TestLazyFetch.assertEquals((int)N_EMPS, (int)emps.size());
        List managers = em.createQuery("Select m from D_F_Manager m").getResultList();
        TestLazyFetch.assertEquals((int)1, (int)managers.size());
        Manager m = (Manager)managers.get(0);
        for (Employee e : emps) {
            TestLazyFetch.assertNotNull((Object)e.getManager());
            TestLazyFetch.assertTrue((boolean)m.getEmployees().contains(e));
            TestLazyFetch.assertEquals((Object)m, (Object)e.getManager());
        }
        em.close();
        emf.close();
    }
}

