/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detachment.model.SimpleA;
import org.apache.openjpa.persistence.detachment.model.SimpleB;
import org.apache.openjpa.persistence.detachment.model.SimpleC;
import org.apache.openjpa.persistence.detachment.model.SimpleRef;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestNoCascadeOneToOneMerge
extends SingleEMFTestCase {
    private int a_id;
    private int b1_id;
    private int b2_id;

    public void setUp() {
        this.setUp(SimpleA.class, SimpleRef.class, SimpleB.class, SimpleC.class, "openjpa.Compatibility", "FlushBeforeDetach=true,CopyOnDetach=true", CLEAR_TABLES);
        this.createEntities();
    }

    private void createEntities() {
        SimpleRef b1 = new SimpleRef();
        b1.setName("b1-name");
        SimpleRef b2 = new SimpleRef();
        b2.setName("b2-name");
        SimpleA a = new SimpleA();
        a.setName("a-name");
        a.setRef(b1);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)b1);
        em.persist((Object)b2);
        em.persist((Object)a);
        em.getTransaction().commit();
        em.close();
        this.a_id = a.getId();
        this.b1_id = b1.getId();
        this.b2_id = b2.getId();
    }

    public void testMergeAllAttached() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SimpleA a = (SimpleA)em.find(SimpleA.class, (Object)this.a_id);
        SimpleRef b2 = (SimpleRef)em.find(SimpleRef.class, (Object)this.b2_id);
        TestNoCascadeOneToOneMerge.assertNotNull((Object)a);
        TestNoCascadeOneToOneMerge.assertNotNull((Object)b2);
        a.setRef(b2);
        em.getTransaction().begin();
        em.merge((Object)a);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        a = (SimpleA)em.find(SimpleA.class, (Object)this.a_id);
        em.close();
        TestNoCascadeOneToOneMerge.assertNotNull((Object)a);
        TestNoCascadeOneToOneMerge.assertEquals((int)this.b2_id, (int)a.getRef().getId());
    }

    public void testMergeRefAttached() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SimpleA a = (SimpleA)em.find(SimpleA.class, (Object)this.a_id);
        TestNoCascadeOneToOneMerge.assertNotNull((Object)a);
        em.close();
        em = this.emf.createEntityManager();
        SimpleRef b2 = (SimpleRef)em.find(SimpleRef.class, (Object)this.b2_id);
        TestNoCascadeOneToOneMerge.assertNotNull((Object)b2);
        a.setRef(b2);
        em.getTransaction().begin();
        em.merge((Object)a);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        a = (SimpleA)em.find(SimpleA.class, (Object)this.a_id);
        em.close();
        TestNoCascadeOneToOneMerge.assertNotNull((Object)a);
        TestNoCascadeOneToOneMerge.assertEquals((int)this.b2_id, (int)a.getRef().getId());
    }

    public void testMergeDetached() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SimpleA a = (SimpleA)em.find(SimpleA.class, (Object)this.a_id);
        SimpleRef b1 = (SimpleRef)em.find(SimpleRef.class, (Object)this.b1_id);
        SimpleRef b2 = (SimpleRef)em.find(SimpleRef.class, (Object)this.b2_id);
        TestNoCascadeOneToOneMerge.assertNotNull((Object)a);
        TestNoCascadeOneToOneMerge.assertNotNull((Object)b1);
        TestNoCascadeOneToOneMerge.assertNotNull((Object)b2);
        em.close();
        a.setRef(b2);
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.merge((Object)a);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        a = (SimpleA)em.find(SimpleA.class, (Object)this.a_id);
        em.close();
        TestNoCascadeOneToOneMerge.assertNotNull((Object)a);
        TestNoCascadeOneToOneMerge.assertEquals((int)this.b2_id, (int)a.getRef().getId());
    }

    public static void main(String[] args) {
        TestRunner.run(TestNoCascadeOneToOneMerge.class);
    }
}

