/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.detachment.DetachmentOneManyChild;
import org.apache.openjpa.persistence.detachment.DetachmentOneManyParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestGetReferenceAndImplicitDetachment
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp("openjpa.DetachState", "fetch-groups", DetachmentOneManyParent.class, DetachmentOneManyChild.class);
    }

    public void testNonexistentGetReferenceDetachmentInTxWithCommit() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        DetachmentOneManyParent o = (DetachmentOneManyParent)em.getReference(DetachmentOneManyParent.class, (Object)0);
        em.getTransaction().commit();
        em.close();
        TestGetReferenceAndImplicitDetachment.assertFalse((boolean)((PersistenceCapable)o).pcIsTransactional());
        TestGetReferenceAndImplicitDetachment.assertFalse((boolean)((PersistenceCapable)o).pcIsPersistent());
    }

    public void testNonexistentGetReferenceDetachmentOutsideTx() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DetachmentOneManyParent o = (DetachmentOneManyParent)em.getReference(DetachmentOneManyParent.class, (Object)0);
        em.close();
        TestGetReferenceAndImplicitDetachment.assertFalse((boolean)((PersistenceCapable)o).pcIsTransactional());
        TestGetReferenceAndImplicitDetachment.assertFalse((boolean)((PersistenceCapable)o).pcIsPersistent());
    }

    public void testNonexistentGetReferenceDetachmentInTxWithRollback() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        DetachmentOneManyParent o = (DetachmentOneManyParent)em.getReference(DetachmentOneManyParent.class, (Object)0);
        em.getTransaction().rollback();
        TestGetReferenceAndImplicitDetachment.assertFalse((boolean)OpenJPAPersistence.cast((EntityManager)em).isTransactional((Object)o));
        TestGetReferenceAndImplicitDetachment.assertFalse((boolean)OpenJPAPersistence.cast((EntityManager)em).isPersistent((Object)o));
        em.close();
    }

    public void testNonexistentGetReferenceDetachmentInTxWithFailedCommit() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        DetachmentOneManyParent o = (DetachmentOneManyParent)em.getReference(DetachmentOneManyParent.class, (Object)0);
        em.getTransaction().setRollbackOnly();
        try {
            em.getTransaction().commit();
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        TestGetReferenceAndImplicitDetachment.assertFalse((boolean)OpenJPAPersistence.cast((EntityManager)em).isTransactional((Object)o));
        TestGetReferenceAndImplicitDetachment.assertFalse((boolean)OpenJPAPersistence.cast((EntityManager)em).isPersistent((Object)o));
        em.close();
    }
}

