/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import javax.persistence.EntityManager;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.AutoDetachType;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.detachment.DetachmentOneManyChild;
import org.apache.openjpa.persistence.detachment.DetachmentOneManyParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetachmentOneMany
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(DetachmentOneManyParent.class, DetachmentOneManyChild.class);
    }

    public void testDetachment() {
        long id = this.createParentAndChildren();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAPersistence.cast((EntityManager)em).setAutoDetach(AutoDetachType.NON_TRANSACTIONAL_READ);
        DetachmentOneManyParent parent = (DetachmentOneManyParent)em.find(DetachmentOneManyParent.class, (Object)id);
        TestDetachmentOneMany.assertNotNull((Object)parent);
        TestDetachmentOneMany.assertFalse((String)"The parent was not detached", (boolean)em.contains((Object)parent));
        em.close();
    }

    public void testFetchWithDetach() {
        long id = this.createParentAndChildren();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAPersistence.cast((EntityManager)em).setAutoDetach(AutoDetachType.NON_TRANSACTIONAL_READ);
        DetachmentOneManyParent parent = (DetachmentOneManyParent)em.find(DetachmentOneManyParent.class, (Object)id);
        TestDetachmentOneMany.assertNotNull((Object)parent);
        TestDetachmentOneMany.assertEquals((String)"parent", (String)parent.getName());
        TestDetachmentOneMany.assertEquals((int)2, (int)parent.getChildren().size());
        DetachmentOneManyChild child0 = parent.getChildren().get(0);
        DetachmentOneManyChild child1 = parent.getChildren().get(1);
        TestDetachmentOneMany.assertNotNull((String)"Did not find expected first child", (Object)child0);
        TestDetachmentOneMany.assertNotNull((String)"Did not find expected second child", (Object)child1);
        TestDetachmentOneMany.assertEquals((String)"child0", (String)child0.getName());
        TestDetachmentOneMany.assertFalse((String)"The first child was not detached", (boolean)em.contains((Object)child0));
        TestDetachmentOneMany.assertEquals((String)"child1", (String)child1.getName());
        TestDetachmentOneMany.assertFalse((String)"The second child was not detached", (boolean)em.contains((Object)child1));
        em.close();
    }

    public void testFetchWithDetachForToOneRelationship() {
        long id = this.createParentAndChildren();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAPersistence.cast((EntityManager)em).setAutoDetach(AutoDetachType.NON_TRANSACTIONAL_READ);
        DetachmentOneManyParent parent = (DetachmentOneManyParent)em.find(DetachmentOneManyParent.class, (Object)id);
        TestDetachmentOneMany.assertNotNull((Object)parent);
        TestDetachmentOneMany.assertEquals((int)2, (int)parent.getChildren().size());
        TestDetachmentOneMany.assertEquals((String)"ToOne relationship was not eagerly fetched", (Object)parent, (Object)parent.getChildren().get(0).getParent());
        em.close();
    }

    private long createParentAndChildren() {
        DetachmentOneManyParent parent = new DetachmentOneManyParent();
        parent.setName("parent");
        for (int i = 0; i < 2; ++i) {
            DetachmentOneManyChild child = new DetachmentOneManyChild();
            child.setName("child" + i);
            parent.addChild(child);
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)parent);
        em.getTransaction().commit();
        long id = parent.getId();
        TestDetachmentOneMany.assertNotNull(parent.getChildren());
        TestDetachmentOneMany.assertEquals((int)2, (int)parent.getChildren().size());
        TestDetachmentOneMany.assertTrue((String)"The parent is not managed", (boolean)em.contains((Object)parent));
        DetachmentOneManyChild child0 = parent.getChildren().get(0);
        DetachmentOneManyChild child1 = parent.getChildren().get(1);
        TestDetachmentOneMany.assertEquals((String)"child0", (String)child0.getName());
        TestDetachmentOneMany.assertEquals((String)"child1", (String)child1.getName());
        TestDetachmentOneMany.assertEquals((String)"The first child has no relationship to the parent", (Object)parent, (Object)child0.getParent());
        TestDetachmentOneMany.assertEquals((String)"The second child has no relationship to the parent", (Object)parent, (Object)child1.getParent());
        em.close();
        return id;
    }

    public static void main(String[] args) {
        TestRunner.run(TestDetachmentOneMany.class);
    }
}

