/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detachment.Record;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetachment
extends SingleEMFTestCase {
    private int id;

    public void setUp() {
        super.setUp(Record.class);
        this.id = this.prepare();
    }

    public void testAttachWithNewString() {
        Record record = this.detach(this.id);
        record.setContent("a text different than the one in the record");
        this.attach(record);
    }

    public void testSetSameStringInstance() {
        Record record = this.detach(this.id);
        record.setContent(record.getContent());
        this.attach(record);
    }

    public void testSetSameString() {
        Record record = this.detach(this.id);
        record.setContent(record.getContent() + "");
        this.attach(record);
    }

    private int prepare() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Record record = new Record();
        record.setContent("default");
        em.persist((Object)record);
        em.getTransaction().commit();
        em.close();
        return record.getId();
    }

    private Record detach(int id) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Record record = (Record)em.find(Record.class, (Object)id);
        em.close();
        return record;
    }

    private void attach(Record record) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        record = (Record)em.merge((Object)record);
        em.getTransaction().commit();
        em.close();
    }
}

