/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detachment.model.NoDetachedStateEntityFieldAccess;
import org.apache.openjpa.persistence.detachment.model.NoDetachedStateEntityPropertyAccess;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetachNoStateField
extends SingleEMFTestCase {
    protected void setUp(Object ... props) {
        super.setUp(DROP_TABLES, "openjpa.DetachState", "loaded(DetachedStateField=false)", NoDetachedStateEntityPropertyAccess.class, NoDetachedStateEntityFieldAccess.class);
        this.loadDB();
    }

    public void testIsDetchedNoStateManagerZeroVersionField() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        NoDetachedStateEntityPropertyAccess property = (NoDetachedStateEntityPropertyAccess)em.find(NoDetachedStateEntityPropertyAccess.class, (Object)1);
        NoDetachedStateEntityFieldAccess field = (NoDetachedStateEntityFieldAccess)em.find(NoDetachedStateEntityFieldAccess.class, (Object)1);
        em.close();
        PersistenceCapable pcProperty = (PersistenceCapable)property;
        PersistenceCapable pcField = (PersistenceCapable)field;
        TestDetachNoStateField.assertTrue((boolean)pcProperty.pcIsDetached());
        TestDetachNoStateField.assertTrue((boolean)pcField.pcIsDetached());
    }

    public void testPersistRelationshipToDetchedEntityZeroVersion() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        NoDetachedStateEntityPropertyAccess property = (NoDetachedStateEntityPropertyAccess)em.find(NoDetachedStateEntityPropertyAccess.class, (Object)1);
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        NoDetachedStateEntityFieldAccess field = (NoDetachedStateEntityFieldAccess)em.find(NoDetachedStateEntityFieldAccess.class, (Object)1);
        field.setRelationship(property);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        field = (NoDetachedStateEntityFieldAccess)em.find(NoDetachedStateEntityFieldAccess.class, (Object)1);
        property = field.getRelationship();
        TestDetachNoStateField.assertNotNull((Object)property);
        TestDetachNoStateField.assertEquals((int)1, (int)property.getId());
    }

    public void testSetVersionPropertyAccess() {
        NoDetachedStateEntityPropertyAccess entity = new NoDetachedStateEntityPropertyAccess();
        entity.setVersion(1);
    }

    void loadDB() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.createNativeQuery("INSERT INTO PropertyAccessNoDetachedState (ID,VERSION) VALUES (1,0)").executeUpdate();
        em.createNativeQuery("INSERT INTO FieldAccessNoDetachedState (ID,VERSION) VALUES (1,0)").executeUpdate();
        em.getTransaction().commit();
        em.close();
    }
}

