/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.persistence.detachment.TestDetach;
import org.apache.openjpa.persistence.detachment.model.DMCustomer;
import org.apache.openjpa.persistence.detachment.model.DMCustomerInventory;
import org.apache.openjpa.persistence.detachment.model.DMItem;

public class TestDetachLite
extends TestDetach {
    public void setUp() {
        super.setUp("openjpa.DetachState", "loaded(LiteAutoDetach=true)", DMCustomer.class, DMCustomerInventory.class, DMItem.class, CLEAR_TABLES);
        Compatibility compat = this.emf.getConfiguration().getCompatibilityInstance();
        compat.setCopyOnDetach(false);
        compat.setFlushBeforeDetach(false);
        this.em = this.emf.createEntityManager();
        this.root = this.createData();
    }

    public void testCloseDetach() {
        this.root = (DMCustomer)this.em.merge((Object)this.root);
        PersistenceCapable pc = (PersistenceCapable)this.root;
        TestDetachLite.assertFalse((boolean)pc.pcIsDetached());
        this.em.close();
        TestDetachLite.assertTrue((boolean)pc.pcIsDetached());
        for (DMCustomerInventory c : this.root.getCustomerInventories()) {
            pc = (PersistenceCapable)c;
            TestDetachLite.assertTrue((boolean)pc.pcIsDetached());
            pc = (PersistenceCapable)c.getItem();
            TestDetachLite.assertTrue((boolean)pc.pcIsDetached());
        }
    }
}

