/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import javax.persistence.OptimisticLockException;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detachment.DetachmentOneManyChild;
import org.apache.openjpa.persistence.detachment.DetachmentOneManyParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestAttachWithNoChanges
extends SingleEMFTestCase {
    public void setUp() {
        this.setUp(DetachmentOneManyParent.class, DetachmentOneManyChild.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachWithNoChangesChecksVersion() {
        DetachmentOneManyChild e = new DetachmentOneManyChild();
        DetachmentOneManyParent p = new DetachmentOneManyParent();
        e.setName("orig");
        p.addChild(e);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)p);
        em.persist((Object)e);
        em.flush();
        em.clear();
        DetachmentOneManyChild changed = (DetachmentOneManyChild)em.find(DetachmentOneManyChild.class, (Object)e.getId());
        changed.setName("newname");
        em.flush();
        em.merge((Object)e);
        try {
            em.flush();
            TestAttachWithNoChanges.fail((String)"Should not be able to flush old version over new.");
        }
        catch (OptimisticLockException ole) {
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    public static void main(String[] args) {
        TestRunner.run(TestAttachWithNoChanges.class);
    }
}

