/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detach;

import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.detach.IntVersionEntity;
import org.apache.openjpa.persistence.detach.NoVersionEntity;
import org.apache.openjpa.persistence.detach.TimestampVersionEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestDetachReloadProp
extends SQLListenerTestCase {
    IntVersionEntity intVer;
    TimestampVersionEntity tsVer;
    NoVersionEntity noVer;
    int id;
    OpenJPAEntityManager em;
    Compatibility compat;

    public void setUp() {
        this.setUp(IntVersionEntity.class, TimestampVersionEntity.class, NoVersionEntity.class);
        this.compat = this.emf.getConfiguration().getCompatibilityInstance();
        ++this.id;
        this.create(this.id);
        this.persist();
    }

    private void create(int id) {
        this.intVer = new IntVersionEntity(id);
        this.intVer.setName("xxx");
        this.tsVer = new TimestampVersionEntity(id);
        this.tsVer.setName("yyy");
        this.intVer.setE2(this.tsVer);
        this.noVer = new NoVersionEntity(id);
        this.noVer.setName("zzz");
    }

    private void persist() {
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.noVer);
        this.em.persist((Object)this.intVer);
        this.em.getTransaction().commit();
        this.em.close();
    }

    public void testReloadTrue() {
        this.compat.setReloadOnDetach(true);
        this.detachProcessing();
    }

    public void testReloadFalse() {
        this.compat.setReloadOnDetach(false);
        this.detachProcessing();
    }

    private void detachProcessing() {
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.intVer = (IntVersionEntity)this.em.find(IntVersionEntity.class, (Object)this.id);
        this.tsVer = (TimestampVersionEntity)this.em.find(TimestampVersionEntity.class, (Object)this.id);
        this.noVer = (NoVersionEntity)this.em.find(NoVersionEntity.class, (Object)this.id);
        this.em.detach((Object)this.intVer);
        this.em.detach((Object)this.tsVer);
        this.em.detach((Object)this.noVer);
        this.em.getTransaction().commit();
        this.em.close();
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.intVer = (IntVersionEntity)this.em.find(IntVersionEntity.class, (Object)this.id);
        this.tsVer = (TimestampVersionEntity)this.em.find(TimestampVersionEntity.class, (Object)this.id);
        this.noVer = (NoVersionEntity)this.em.find(NoVersionEntity.class, (Object)this.id);
        this.em.getTransaction().commit();
        this.em.close();
    }
}

