/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detach;

import java.util.Collection;
import java.util.HashSet;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.detach.Entity1;
import org.apache.openjpa.persistence.detach.Entity14;
import org.apache.openjpa.persistence.detach.Entity7;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetachNoCascade
extends SingleEMFTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    Compatibility compat;
    Entity1 e1;
    Entity7 e7;
    Entity14 e14;
    Collection<Object> allEntities = new HashSet<Object>();

    public void setUp() throws Exception {
        this.setUp(Entity1.class, Entity7.class, Entity14.class, CLEAR_TABLES);
        TestDetachNoCascade.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestDetachNoCascade.assertNotNull((Object)this.em);
        this.compat = this.emf.getConfiguration().getCompatibilityInstance();
        this.compat.setFlushBeforeDetach(true);
        this.compat.setCopyOnDetach(false);
        this.compat.setCascadeWithDetach(false);
    }

    private void create(int id) {
        this.allEntities.clear();
        this.e1 = new Entity1(id, "entity1");
        this.allEntities.add(this.e1);
        this.e7 = new Entity7(id, "entity7");
        this.allEntities.add(this.e7);
        this.e14 = new Entity14(id, "entity14");
        this.allEntities.add(this.e14);
        this.e1.setE14(this.e14);
    }

    public void testDefaults() {
        TestDetachNoCascade.assertTrue((boolean)this.compat.getFlushBeforeDetach());
        TestDetachNoCascade.assertFalse((boolean)this.compat.getCopyOnDetach());
        TestDetachNoCascade.assertFalse((boolean)this.compat.getCascadeWithDetach());
    }

    public void testCascadeValues() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        this.em.getTransaction().commit();
        MetaDataRepository repos = this.emf.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta = repos.getCachedMetaData(Entity1.class);
        TestDetachNoCascade.assertNotNull((Object)meta);
        TestDetachNoCascade.assertEquals((int)0, (int)meta.getField("id").getCascadeDetach());
        TestDetachNoCascade.assertEquals((int)0, (int)meta.getField("name").getCascadeDetach());
        TestDetachNoCascade.assertEquals((int)0, (int)meta.getField("e14").getCascadeDetach());
    }

    public void testClearAll() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        TestDetachNoCascade.assertEquals((int)this.allEntities.size(), (int)this.em.getManagedObjects().size());
        this.em.clear();
        TestDetachNoCascade.assertEquals((int)0, (int)this.em.getManagedObjects().size());
        TestDetachNoCascade.assertFalse((boolean)this.em.contains((Object)this.e1));
        this.em.getTransaction().commit();
    }

    public void testClearOne() {
        ++this.id;
        boolean cwd = this.compat.getCascadeWithDetach();
        boolean cod = this.compat.getCopyOnDetach();
        this.compat.setCascadeWithDetach(false);
        this.compat.setCopyOnDetach(false);
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        TestDetachNoCascade.assertTrue((boolean)this.em.contains((Object)this.e1));
        this.em.detach((Object)this.e1);
        TestDetachNoCascade.assertFalse((boolean)this.em.contains((Object)this.e1));
        TestDetachNoCascade.assertTrue((boolean)this.em.contains((Object)this.e14));
        TestDetachNoCascade.assertTrue((boolean)this.em.contains((Object)this.e7));
        this.em.getTransaction().commit();
        this.compat.setCascadeWithDetach(cwd);
        this.compat.setCopyOnDetach(cod);
    }

    public void testClearNew() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        TestDetachNoCascade.assertFalse((boolean)this.em.contains((Object)this.e1));
        this.em.detach((Object)this.e1);
        this.em.persistAll(this.allEntities);
        TestDetachNoCascade.assertTrue((boolean)this.em.contains((Object)this.e1));
        this.em.getTransaction().commit();
    }

    public void testClearDirty() {
        boolean cod = this.compat.getCopyOnDetach();
        boolean fbd = this.compat.getFlushBeforeDetach();
        this.compat.setCopyOnDetach(false);
        this.compat.setFlushBeforeDetach(false);
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        this.e1 = (Entity1)this.em.find(Entity1.class, (Object)this.id);
        TestDetachNoCascade.assertEquals((String)"entity1", (String)this.e1.getName());
        this.e1.setName("new name");
        this.em.detach((Object)this.e1);
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        this.em.clear();
        this.e1 = (Entity1)this.em.find(Entity1.class, (Object)this.id);
        TestDetachNoCascade.assertNotEquals("new name", this.e1.getName());
        TestDetachNoCascade.assertEquals((String)"entity1", (String)this.e1.getName());
        this.em.getTransaction().commit();
        this.compat.setCopyOnDetach(cod);
        this.compat.setFlushBeforeDetach(fbd);
    }

    public void testClearRemove() {
        boolean cwd = this.compat.getCascadeWithDetach();
        boolean cod = this.compat.getCopyOnDetach();
        this.compat.setCascadeWithDetach(false);
        this.compat.setCopyOnDetach(false);
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        this.e1 = (Entity1)this.em.find(Entity1.class, (Object)this.id);
        this.em.remove((Object)this.e1);
        this.em.detach((Object)this.e1);
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        this.em.clear();
        this.e1 = (Entity1)this.em.find(Entity1.class, (Object)this.id);
        TestDetachNoCascade.assertNotNull((Object)this.e1);
        this.em.getTransaction().commit();
        this.compat.setCascadeWithDetach(cwd);
        this.compat.setCopyOnDetach(cod);
    }

    public void testClearOnClearedEntity() {
        boolean cwd = this.compat.getCascadeWithDetach();
        boolean cod = this.compat.getCopyOnDetach();
        this.compat.setCascadeWithDetach(false);
        this.compat.setCopyOnDetach(false);
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persist((Object)this.e1);
        this.em.detach((Object)this.e1);
        this.em.detach((Object)this.e1);
        TestDetachNoCascade.assertFalse((boolean)this.em.contains((Object)this.e1));
        this.em.getTransaction().commit();
        this.compat.setCascadeWithDetach(cwd);
        this.compat.setCopyOnDetach(cod);
    }

    public void testNoCopy() {
        boolean cwd = this.compat.getCascadeWithDetach();
        boolean cod = this.compat.getCopyOnDetach();
        this.compat.setCascadeWithDetach(false);
        this.compat.setCopyOnDetach(false);
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persist((Object)this.e1);
        Entity14 e14PreDetach = this.e1.getE14();
        this.compat.setCascadeWithDetach(true);
        this.em.detach((Object)this.e1);
        TestDetachNoCascade.assertEquals((Object)this.e14, (Object)e14PreDetach);
        TestDetachNoCascade.assertFalse((boolean)this.em.contains((Object)this.e1));
        TestDetachNoCascade.assertFalse((boolean)this.em.contains((Object)this.e14));
        this.em.getTransaction().commit();
        this.compat.setCascadeWithDetach(false);
        this.compat.setCascadeWithDetach(cwd);
        this.compat.setCopyOnDetach(cod);
    }

    public void testCopy() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persist((Object)this.e1);
        Entity1 e1Det = (Entity1)this.em.detachCopy((Object)this.e1);
        TestDetachNoCascade.assertNotEquals(this.e1, e1Det);
        TestDetachNoCascade.assertTrue((boolean)this.em.contains((Object)this.e1));
        this.em.getTransaction().commit();
        this.compat.setCopyOnDetach(false);
    }

    public void testFlush() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        this.em.getTransaction().commit();
        this.compat.setFlushBeforeDetach(true);
        this.em.getTransaction().begin();
        this.e1 = (Entity1)this.em.find(Entity1.class, (Object)this.id);
        TestDetachNoCascade.assertEquals((String)"entity1", (String)this.e1.getName());
        this.e1.setName("new name");
        this.em.detach((Object)this.e1);
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        this.em.clear();
        this.e1 = (Entity1)this.em.find(Entity1.class, (Object)this.id);
        TestDetachNoCascade.assertEquals((String)"new name", (String)this.e1.getName());
        this.em.getTransaction().commit();
        this.compat.setFlushBeforeDetach(false);
    }

    public void testClearRecreate() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        this.em.detach((Object)this.e1);
        this.em.merge((Object)this.e1);
        this.em.getTransaction().commit();
        this.em.getTransaction().begin();
        this.em.clear();
        Entity1 newE1 = (Entity1)this.em.find(Entity1.class, (Object)this.id);
        TestDetachNoCascade.assertNotNull((Object)newE1);
        this.em.getTransaction().commit();
    }
}

