/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detach;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.detach.Entity1;
import org.apache.openjpa.persistence.detach.Entity10;
import org.apache.openjpa.persistence.detach.Entity11;
import org.apache.openjpa.persistence.detach.Entity12;
import org.apache.openjpa.persistence.detach.Entity13;
import org.apache.openjpa.persistence.detach.Entity14;
import org.apache.openjpa.persistence.detach.Entity3;
import org.apache.openjpa.persistence.detach.Entity4;
import org.apache.openjpa.persistence.detach.Entity5;
import org.apache.openjpa.persistence.detach.Entity6;
import org.apache.openjpa.persistence.detach.Entity7;
import org.apache.openjpa.persistence.detach.Entity8;
import org.apache.openjpa.persistence.detach.Entity9;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetachCascade
extends SingleEMFTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    Compatibility compat;
    Entity1 e1;
    Entity3 e3;
    Entity4 e4;
    Entity5 e5;
    Entity6 e6;
    Entity7 e7;
    Entity8 e8;
    Entity8 e8a;
    Entity9 e9;
    Entity10 e10;
    Entity11 e11;
    Entity12 e12;
    Entity13 e13;
    Entity14 e14;
    Collection<Object> allEntities = new HashSet<Object>();

    public void setUp() throws Exception {
        this.setUp(Entity1.class, Entity3.class, Entity4.class, Entity5.class, Entity6.class, Entity7.class, Entity8.class, Entity9.class, Entity10.class, Entity11.class, Entity12.class, Entity13.class, Entity14.class);
        TestDetachCascade.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestDetachCascade.assertNotNull((Object)this.em);
        this.compat = this.emf.getConfiguration().getCompatibilityInstance();
        TestDetachCascade.assertNotNull((Object)this.compat);
        this.compat.setFlushBeforeDetach(false);
        this.compat.setCopyOnDetach(false);
        this.compat.setCascadeWithDetach(true);
    }

    private void create(int id) {
        this.allEntities.clear();
        this.e1 = new Entity1(id, "entity1");
        this.allEntities.add(this.e1);
        this.e3 = new Entity3(id, "entity3");
        this.allEntities.add(this.e3);
        this.e4 = new Entity4(id, "entity4");
        this.allEntities.add(this.e4);
        this.e5 = new Entity5(id, "entity5");
        this.allEntities.add(this.e5);
        this.e6 = new Entity6(id, "entity6");
        this.allEntities.add(this.e6);
        this.e7 = new Entity7(id, "entity7");
        this.allEntities.add(this.e7);
        this.e8 = new Entity8(id, "entity8");
        this.allEntities.add(this.e8);
        this.e8a = new Entity8(id + 100, "entity8a");
        this.allEntities.add(this.e8a);
        this.e9 = new Entity9(id, "entity9");
        this.allEntities.add(this.e9);
        this.e10 = new Entity10(id, "entity10");
        this.allEntities.add(this.e10);
        this.e11 = new Entity11(id, "entity11");
        this.allEntities.add(this.e11);
        this.e12 = new Entity12(id, "entity12");
        this.allEntities.add(this.e12);
        this.e13 = new Entity13(id, "entity13");
        this.allEntities.add(this.e13);
        this.e14 = new Entity14(id, "entity14");
        this.allEntities.add(this.e14);
        this.e1.setE14(this.e14);
        this.e3.setE4(this.e4);
        this.e4.setE5(this.e5);
        this.e5.setE6(this.e6);
        this.e6.setE7(this.e7);
        this.e8.setE9(this.e9);
        HashSet<Entity8> collection = new HashSet<Entity8>();
        collection.add(this.e8);
        collection.add(this.e8a);
        this.e10.setCollection(collection);
        HashMap<String, Entity11> map = new HashMap<String, Entity11>();
        map.put(this.e11.getName(), this.e11);
        this.e13.setMap(map);
    }

    public void testCascadeValues() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        this.em.getTransaction().commit();
        MetaDataRepository repos = this.emf.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta3 = repos.getCachedMetaData(Entity3.class);
        TestDetachCascade.assertNotNull((Object)meta3);
        TestDetachCascade.assertEquals((int)1, (int)meta3.getField("e4").getCascadeDetach());
        ClassMetaData meta4 = repos.getCachedMetaData(Entity4.class);
        TestDetachCascade.assertNotNull((Object)meta4);
        TestDetachCascade.assertEquals((int)1, (int)meta4.getField("e5").getCascadeDetach());
    }

    public void testNoCascade() {
        boolean cwd = this.compat.getCascadeWithDetach();
        this.compat.setCascadeWithDetach(false);
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e1));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e14));
        this.em.detach((Object)this.e1);
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e1));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e14));
        this.em.getTransaction().commit();
        this.compat.setCascadeWithDetach(cwd);
    }

    public void testAlwaysCascade() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e1));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e14));
        this.compat.setCascadeWithDetach(true);
        this.em.detach((Object)this.e1);
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e1));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e14));
        this.em.getTransaction().commit();
        this.compat.setCascadeWithDetach(false);
    }

    public void testCascadeOfEntities() {
        boolean cwd = this.compat.getCascadeWithDetach();
        this.compat.setCascadeWithDetach(false);
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e3));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e4));
        this.em.detach((Object)this.e3);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e1));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e3));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e4));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e5));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e6));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e7));
        this.em.getTransaction().commit();
        this.compat.setCascadeWithDetach(cwd);
    }

    public void testAlwaysCascadeOfEntities() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e3));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e4));
        this.compat.setCascadeWithDetach(true);
        this.em.detach((Object)this.e3);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e1));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e3));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e4));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e5));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e6));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e7));
        this.em.getTransaction().commit();
        this.compat.setCascadeWithDetach(false);
    }

    public void testSingleCascadeNoFetch() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e3));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e4));
        this.em.getTransaction().commit();
        this.em.close();
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.em.clear();
        this.e3 = (Entity3)this.em.find(Entity3.class, (Object)this.id);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e3));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e4));
        this.em.getTransaction().commit();
        this.em.detach((Object)this.e3);
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e3));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e4));
    }

    public void testCascadeOfCollection() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persist((Object)this.e10);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e10));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e8));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e9));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e8a));
        this.em.detach((Object)this.e10);
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e10));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e8));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e9));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e8a));
        this.em.getTransaction().commit();
    }

    public void testCascadeOfMap() {
        ++this.id;
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e11));
        TestDetachCascade.assertTrue((boolean)this.em.contains((Object)this.e13));
        this.em.detach((Object)this.e13);
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e13));
        TestDetachCascade.assertFalse((boolean)this.em.contains((Object)this.e11));
        this.em.getTransaction().commit();
    }

    public void testOldDetachBehavior() {
        ++this.id;
        this.compat.setFlushBeforeDetach(true);
        this.em.getTransaction().begin();
        this.create(this.id);
        this.em.persistAll(this.allEntities);
        Entity1 e1Det = (Entity1)this.em.detachCopy((Object)this.e1);
        TestDetachCascade.assertNotEquals(this.e1, e1Det);
        Entity14 e14Det = this.e1.getE14();
        TestDetachCascade.assertEquals((Object)this.e14, (Object)e14Det);
        this.em.getTransaction().commit();
        Entity1 e1Saved = (Entity1)this.em.find(Entity1.class, (Object)this.id);
        TestDetachCascade.assertNotNull((Object)e1Saved);
        Entity14 e14Saved = e1Saved.getE14();
        TestDetachCascade.assertNotNull((Object)e14Saved);
        this.compat.setFlushBeforeDetach(false);
    }
}

