/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.derivedid;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.derivedid.EBigDecimalID;
import org.apache.openjpa.persistence.derivedid.EBigIntegerID;
import org.apache.openjpa.persistence.derivedid.EDBigDecimalID;
import org.apache.openjpa.persistence.derivedid.EDBigIntegerID;
import org.apache.openjpa.persistence.derivedid.EDDateID;
import org.apache.openjpa.persistence.derivedid.EDSQLDateID;
import org.apache.openjpa.persistence.derivedid.EDateID;
import org.apache.openjpa.persistence.derivedid.ESQLDateID;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestDerivedIdentity
extends SQLListenerTestCase {
    public void setUp() {
        this.setUp(EBigDecimalID.class, EDBigDecimalID.class, EBigIntegerID.class, EDBigIntegerID.class, EDateID.class, EDDateID.class, ESQLDateID.class, EDSQLDateID.class, CLEAR_TABLES);
        this.populate();
    }

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (int i = 0; i < 2; ++i) {
            long time = System.currentTimeMillis() / 1000L + (long)(i * 1317);
            BigDecimal did = new BigDecimal(time);
            EBigDecimalID e1 = new EBigDecimalID(did);
            EDBigDecimalID e2 = new EDBigDecimalID(e1);
            em.persist((Object)e1);
            em.persist((Object)e2);
            int time2 = (int)(System.currentTimeMillis() / 1000L) + i * 7131;
            BigInteger iid = new BigInteger(Integer.toString(time2));
            EBigIntegerID e3 = new EBigIntegerID(iid);
            EDBigIntegerID e4 = new EDBigIntegerID(e3);
            em.persist((Object)e3);
            em.persist((Object)e4);
            Date id = new Date(time);
            EDateID e5 = new EDateID(id);
            EDDateID e6 = new EDDateID(e5);
            em.persist((Object)e5);
            em.persist((Object)e6);
            if (i != 0) continue;
            java.sql.Date sid = new java.sql.Date(time);
            ESQLDateID e7 = new ESQLDateID(sid);
            EDSQLDateID e8 = new EDSQLDateID(e7);
            em.persist((Object)e7);
            em.persist((Object)e8);
        }
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.close();
    }

    public void testDerivedIdentity() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query query = null;
        String[] str = new String[]{"select e from EDDateID e", "select e from EDBigDecimalID e", "select e from EDBigIntegerID e", "select e from EDSQLDateID e", "select e from EDDateID e join fetch e.rid", "select e from EDBigDecimalID e join fetch e.rid", "select e from EDBigIntegerID e join fetch e.rid", "select e from EDSQLDateID e join fetch e.rid"};
        for (int i = 0; i < str.length; ++i) {
            query = em.createQuery(str[i]);
            List rs = query.getResultList();
            TestDerivedIdentity.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
            for (int j = 0; j < rs.size(); ++j) {
                Object e = rs.get(j);
                String name = null;
                Comparable<Date> oid = null;
                if (e instanceof EDDateID) {
                    name = ((EDDateID)e).getName();
                    oid = ((EDDateID)e).getRid().getId();
                } else if (e instanceof EDBigDecimalID) {
                    name = ((EDBigDecimalID)e).getName();
                    oid = ((EDBigDecimalID)e).getRid().getId();
                } else if (e instanceof EDBigIntegerID) {
                    name = ((EDBigIntegerID)e).getName();
                    oid = ((EDBigIntegerID)e).getRid().getId();
                } else if (e instanceof EDSQLDateID) {
                    name = ((EDSQLDateID)e).getName();
                    oid = ((EDSQLDateID)e).getRid().getId();
                }
                TestDerivedIdentity.assertTrue((boolean)name.startsWith("Rel"));
            }
        }
        em.close();
    }
}

