/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers.noschema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKeyColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="\"nsprimary entityF\"", uniqueConstraints={@UniqueConstraint(columnNames={"\"nsf name\"", "nsf_nonDelimName"})})
@SecondaryTable(name="\"nssecondary entityF\"", uniqueConstraints={@UniqueConstraint(name="\"nssec unq\"", columnNames={"\"nssecondary name\""})})
public class EntityF {
    @TableGenerator(name="f_id_gen", table="\"nsf id gen\"", pkColumnName="\"nsgen pk\"", valueColumnName="\"nsgen value\"")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="f_id_gen")
    @Id
    private int id;
    @Column(name="\"nsf name\"", columnDefinition="varchar(15)")
    private String name;
    @Column(name="nsf_nonDelimName")
    private String nonDelimName;
    @Column(name="\"nssecondary name\"", table="\"nssecondary entityF\"")
    private String secName;
    @ElementCollection
    @CollectionTable
    private Set<String> nscs = new HashSet<String>();
    @ElementCollection
    @CollectionTable(name="\"nsc DelSet\"")
    private Set<String> nscds = new HashSet<String>();
    @ElementCollection
    @MapKeyColumn
    private Map<String, String> nscollMap = new HashMap<String, String>();
    @ElementCollection
    @MapKeyColumn(name="\"nsmap Key\"", columnDefinition="varchar(20)", table="\"nsd c map\"")
    private Map<String, String> delimCollectionMap = new HashMap<String, String>();

    public EntityF(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNonDelimName() {
        return this.nonDelimName;
    }

    public void setNonDelimName(String nonDelimName) {
        this.nonDelimName = nonDelimName;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public Set<String> getCollectionSet() {
        return this.nscs;
    }

    public void setCollectionSet(Set<String> collectionSet) {
        this.nscs = collectionSet;
    }

    public void addCollectionSet(String item) {
        this.nscs.add(item);
    }

    public Set<String> getCollectionDelimSet() {
        return this.nscds;
    }

    public void setCollectionDelimSet(Set<String> collectionDelimSet) {
        this.nscds = collectionDelimSet;
    }

    public void addCollectionDelimSet(String item) {
        this.nscds.add(item);
    }

    public Map<String, String> getCollectionMap() {
        return this.nscollMap;
    }

    public void setCollectionMap(Map<String, String> collectionMap) {
        this.nscollMap = collectionMap;
    }

    public void addCollectionMap(String key, String value) {
        this.nscollMap.put(key, value);
    }

    public Map<String, String> getDelimCollectionMap() {
        return this.delimCollectionMap;
    }

    public void setDelimCollectionMap(Map<String, String> delimCollectionMap) {
        this.delimCollectionMap = delimCollectionMap;
    }

    public void addDelimCollectionMap(String key, String value) {
        this.delimCollectionMap.put(key, value);
    }
}

