/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.delimited.identifiers.EntityE;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestManualDelimIdSeqGen
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    JDBCConfiguration conf;
    DBDictionary dict;
    boolean supportsNativeSequence = false;
    EntityE entityE;

    public void setUp() throws Exception {
        this.setSupportedDatabases(DB2Dictionary.class, DerbyDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(EntityE.class, DROP_TABLES);
        TestManualDelimIdSeqGen.assertNotNull((Object)this.emf);
        this.conf = (JDBCConfiguration)this.emf.getConfiguration();
        this.dict = this.conf.getDBDictionaryInstance();
        boolean bl = this.supportsNativeSequence = this.dict.nextSequenceQuery != null;
        if (this.supportsNativeSequence) {
            this.em = this.emf.createEntityManager();
            TestManualDelimIdSeqGen.assertNotNull((Object)this.em);
        }
    }

    public void createEntityE() {
        this.entityE = new EntityE("e name");
    }

    public void testSeqGen() {
        if (!this.supportsNativeSequence) {
            return;
        }
        this.createEntityE();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityE);
        this.em.getTransaction().commit();
        int genId = this.entityE.getId();
        this.em.clear();
        this.em.getTransaction().begin();
        EntityE eA = (EntityE)this.em.find(EntityE.class, (Object)genId);
        TestManualDelimIdSeqGen.assertEquals((String)"e name", (String)eA.getName());
        this.em.getTransaction().commit();
        this.em.close();
    }
}

