/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers;

import java.util.List;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.delimited.identifiers.Animal;
import org.apache.openjpa.persistence.delimited.identifiers.Animal2;
import org.apache.openjpa.persistence.delimited.identifiers.Cat;
import org.apache.openjpa.persistence.delimited.identifiers.Cat2;
import org.apache.openjpa.persistence.delimited.identifiers.Dog;
import org.apache.openjpa.persistence.delimited.identifiers.Dog2;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestManualDelimIdResultSetAnnotations
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    Animal animal;
    Dog dog;
    Cat cat;
    Animal2 animal2;
    Dog2 dog2;
    Cat2 cat2;

    public void setUp() throws Exception {
        this.setSupportedDatabases(DB2Dictionary.class, DerbyDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(Animal.class, Dog.class, Cat.class, Animal2.class, Dog2.class, Cat2.class, DROP_TABLES);
        TestManualDelimIdResultSetAnnotations.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestManualDelimIdResultSetAnnotations.assertNotNull((Object)this.em);
    }

    private void createCat(int id) {
        this.cat = new Cat(id);
        this.cat.setName("Puff");
        this.cat.setType("cat");
        this.cat.setAge(3);
    }

    private void createDog(int id) {
        this.dog = new Dog(id);
        this.dog.setName("Spot");
        this.dog.setType("dog");
        this.dog.setAge(9);
    }

    public void testCreate() {
        ++this.id;
        this.createDog(this.id);
        ++this.id;
        this.createCat(this.id);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.dog);
        this.em.persist((Object)this.cat);
        this.em.getTransaction().commit();
        this.runQueries();
    }

    private void runQueries() {
        this.em.clear();
        this.resultSetQuery();
    }

    private void resultSetQuery() {
        String query = "SELECT a.id, a.\"animal type\", a.\"animal name\", a.\"discr col\", a.\"animal age\" FROM \"Animal\" a ";
        OpenJPAQuery q = this.em.createNativeQuery(query, "AnimalResultSet");
        List results = q.getResultList();
        TestManualDelimIdResultSetAnnotations.assertEquals((int)2, (int)results.size());
        for (Object[] result : results) {
            TestManualDelimIdResultSetAnnotations.assertEquals((int)2, (int)result.length);
            TestManualDelimIdResultSetAnnotations.assertTrue((boolean)(result[0] instanceof Animal2));
            TestManualDelimIdResultSetAnnotations.assertTrue((boolean)(result[1] instanceof Integer));
            Animal2 animal2 = (Animal2)result[0];
            Integer age = (Integer)result[1];
            if (animal2.getName().equals("Spot")) {
                TestManualDelimIdResultSetAnnotations.assertEquals((int)9, (int)age);
                continue;
            }
            if (!animal2.getName().equals("Puff")) continue;
            TestManualDelimIdResultSetAnnotations.assertEquals((int)3, (int)age);
        }
    }
}

